/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="OctalNumber", priority=Priority.CRITICAL, tags={"misra", "pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class OctalNumberCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptTokenType.NUMERIC_LITERAL});
    }

    public void visitNode(AstNode astNode) {
        String value = astNode.getTokenValue();
        if (value.length() > 1 && value.startsWith("0")) {
            int newValue;
            try {
                newValue = Integer.parseInt(value, 8);
            }
            catch (NumberFormatException e) {
                return;
            }
            this.getContext().createLineViolation((CodeCheck)this, "Replace the value of the octal number (" + value + ") by its decimal equivalent (" + newValue + ").", astNode, new Object[0]);
        }
    }
}

