/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="RedeclaredFunction", priority=Priority.MAJOR, tags={"bug", "pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class RedeclaredFunctionCheck
extends SquidCheck<LexerlessGrammar> {
    private Stack<Set<String>> stack;

    public void init() {
        this.subscribeTo(CheckUtils.functionNodesArray());
    }

    public void visitFile(AstNode astNode) {
        this.stack = new Stack();
        this.stack.add(new HashSet());
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{Tree.Kind.FUNCTION_DECLARATION})) {
            Set<String> currentScope = this.stack.peek();
            String functionName = astNode.getFirstChild(new AstNodeType[]{Tree.Kind.BINDING_IDENTIFIER}).getTokenValue();
            if (currentScope.contains(functionName)) {
                this.getContext().createLineViolation((CodeCheck)this, "Rename function \"" + functionName + "\" as this name is already used.", astNode, new Object[0]);
            } else {
                currentScope.add(functionName);
            }
        }
        this.stack.add(new HashSet());
    }

    public void leaveNode(AstNode astNode) {
        if (CheckUtils.isFunction(astNode)) {
            this.stack.pop();
        }
    }

    public void leaveFile(AstNode astNode) {
        this.stack = null;
    }
}

