/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Iterables;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.implementations.statement.SwitchStatementTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.SwitchClauseTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="SwitchWithoutDefault", priority=Priority.MAJOR, tags={"cert", "cwe", "misra"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SwitchWithoutDefaultCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.SWITCH_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        SwitchStatementTreeImpl switchStmt = (SwitchStatementTreeImpl)astNode;
        if (!this.hasDefaultCase(switchStmt)) {
            this.getContext().createLineViolation((CodeCheck)this, "Avoid switch statement without a \"default\" clause.", astNode, new Object[0]);
        } else if (!((SwitchClauseTree)Iterables.getLast((Iterable)switchStmt.cases())).is(new Tree.Kind[]{Tree.Kind.DEFAULT_CLAUSE})) {
            this.getContext().createLineViolation((CodeCheck)this, "\"default\" clause should be the last one.", astNode, new Object[0]);
        }
    }

    private boolean hasDefaultCase(SwitchStatementTreeImpl switchStmt) {
        for (SwitchClauseTree clause : switchStmt.cases()) {
            if (!clause.is(new Tree.Kind[]{Tree.Kind.DEFAULT_CLAUSE})) continue;
            return true;
        }
        return false;
    }
}

