/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.resolve.Scope;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.resolve.Usage;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S1854", name="Dead Stores should be removed", priority=Priority.MAJOR, tags={"bug", "cert", "cwe", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class DeadStoreCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Remove this useless assignment to local variable \"%s\"";

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        List symbols = symbolModel.getSymbols(new Symbol.Kind[0]);
        for (Symbol symbol : symbols) {
            this.visitSymbol(symbol, symbolModel);
        }
    }

    private void visitSymbol(Symbol symbol, SymbolModel symbolModel) {
        Scope scope = symbolModel.getScopeFor(symbol);
        if (scope.equals(scope.globalScope())) {
            return;
        }
        LinkedList<Usage> usages = new LinkedList<Usage>(symbolModel.getUsageFor(symbol));
        if (!this.hasRead(usages)) {
            for (Usage usage : usages) {
                if (usage.isInit()) continue;
                this.getContext().addIssue((CodeVisitor)this, (Tree)usage.symbolTree(), String.format(MESSAGE, symbol.name()));
            }
        }
    }

    private boolean hasRead(List<Usage> usages) {
        for (Usage usage : usages) {
            if (!usage.kind().equals((Object)Usage.Kind.READ) && !usage.kind().equals((Object)Usage.Kind.READ_WRITE)) continue;
            return true;
        }
        return false;
    }
}

