/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.BinaryExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.NewExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ParenthesisedExpressionTree;
import org.sonar.javascript.model.interfaces.expression.UnaryExpressionTree;
import org.sonar.javascript.model.interfaces.statement.ForInStatementTree;
import org.sonar.javascript.model.interfaces.statement.ReturnStatementTree;
import org.sonar.javascript.model.interfaces.statement.ThrowStatementTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="Parentheses", name="Useless parentheses around expressions should be removed to prevent any misunderstanding", priority=Priority.MAJOR, tags={"confusing"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class ParenthesesCheck
extends BaseTreeVisitor {
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.DELETE, Tree.Kind.TYPEOF, Tree.Kind.VOID})) {
            this.checkExpression(tree.expression());
        }
        super.visitUnaryExpression(tree);
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
        this.checkExpression(tree.expression());
        super.visitReturnStatement(tree);
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        this.checkExpression(tree.expression());
        super.visitThrowStatement(tree);
    }

    public void visitNewExpression(NewExpressionTree tree) {
        ParenthesisedExpressionTree parenthesisedExpression;
        if (tree.arguments() == null && tree.expression().is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION}) && !((parenthesisedExpression = (ParenthesisedExpressionTree)tree.expression()).expression() instanceof BinaryExpressionTree)) {
            this.checkExpression(tree.expression());
        }
        super.visitNewExpression(tree);
    }

    public void visitForInStatement(ForInStatementTree tree) {
        this.checkExpression(tree.expression());
        super.visitForInStatement(tree);
    }

    private void checkExpression(@Nullable ExpressionTree expression) {
        if (expression != null && expression.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            String expressingString = CheckUtils.asString((Tree)((ParenthesisedExpressionTree)expression).expression());
            this.getContext().addIssue((CodeVisitor)this, (Tree)expression, String.format("The parentheses around \"%s\" are useless.", expressingString));
        }
    }
}

