/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.implementations.statement.IfStatementTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.statement.BlockTree;
import org.sonar.javascript.model.interfaces.statement.ReturnStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1126", name="Return of boolean expressions should not be wrapped into an \"if-then-else\" statement", priority=Priority.MINOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class ReturnOfBooleanExpressionCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.IF_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        IfStatementTreeImpl ifStatement = (IfStatementTreeImpl)astNode;
        if (ReturnOfBooleanExpressionCheck.isNotIfElse(ifStatement) && ifStatement.hasElse() && ReturnOfBooleanExpressionCheck.returnsBoolean((AstNode)ifStatement.elseClause().statement()) && ReturnOfBooleanExpressionCheck.returnsBoolean((AstNode)ifStatement.statement())) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace this if-then-else statement by a single return statement.", astNode, new Object[0]);
        }
    }

    public static boolean isNotIfElse(IfStatementTreeImpl ifStmt) {
        return !ifStmt.getParent().is(new AstNodeType[]{Tree.Kind.ELSE_CLAUSE});
    }

    public static boolean returnsBoolean(AstNode statement) {
        return ReturnOfBooleanExpressionCheck.isBlockReturningBooleanLiteral(statement) || ReturnOfBooleanExpressionCheck.isSimpleReturnBooleanLiteral(statement);
    }

    public static boolean isBlockReturningBooleanLiteral(AstNode statement) {
        if (statement.isNot(new AstNodeType[]{Tree.Kind.BLOCK})) {
            return false;
        }
        BlockTree block = (BlockTree)statement;
        return block.statements().size() == 1 && ReturnOfBooleanExpressionCheck.isSimpleReturnBooleanLiteral((AstNode)block.statements().get(0));
    }

    public static boolean isSimpleReturnBooleanLiteral(AstNode astNode) {
        if (astNode.isNot(new AstNodeType[]{Tree.Kind.RETURN_STATEMENT})) {
            return false;
        }
        ReturnStatementTree statement = (ReturnStatementTree)astNode;
        ExpressionTree expression = statement.expression();
        return expression != null && expression.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL});
    }
}

