/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.squid.SquidAstVisitor;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.javascript.api.EcmaScriptMetric;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLinesVisitor
extends SquidAstVisitor<EcmaScriptGrammar>
implements AstAndTokenVisitor {
    private final Project project;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final Set<Integer> linesOfCode = Sets.newHashSet();
    private final Set<Integer> linesOfComments = Sets.newHashSet();

    public FileLinesVisitor(Project project, FileLinesContextFactory fileLinesContextFactory) {
        this.project = project;
        this.fileLinesContextFactory = fileLinesContextFactory;
    }

    public void visitToken(Token token) {
        if (token.getType().equals(GenericTokenType.EOF)) {
            return;
        }
        this.linesOfCode.add(token.getLine());
        List trivias = token.getTrivia();
        for (Trivia trivia : trivias) {
            if (!trivia.isComment()) continue;
            this.linesOfComments.add(trivia.getToken().getLine());
        }
    }

    public void leaveFile(AstNode astNode) {
        org.sonar.api.resources.File sonarFile = org.sonar.api.resources.File.fromIOFile((File)this.getContext().getFile(), (Project)this.project);
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor((Resource)sonarFile);
        int fileLength = this.getContext().peekSourceCode().getInt((MetricDef)EcmaScriptMetric.LINES);
        for (int line = 1; line <= fileLength; ++line) {
            fileLinesContext.setIntValue("ncloc_data", line, this.linesOfCode.contains(line) ? 1 : 0);
            fileLinesContext.setIntValue("comment_lines_data", line, this.linesOfComments.contains(line) ? 1 : 0);
        }
        fileLinesContext.save();
        this.linesOfCode.clear();
        this.linesOfComments.clear();
    }
}

