/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.lexer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import java.util.List;
import java.util.Set;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;
import org.sonar.javascript.api.EcmaScriptTokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcmaScriptRegexpChannel
extends Channel<Lexer> {
    private static final String ESCAPE_SEQUENCE = "\\\\(?:[^\\r\\n\\u2028\\u2029ux]|u[0-9A-Fa-f]{1,4}|x[0-9A-Fa-f]{2})";
    private static final String CHARSET = "\\[(?:[^\\]\\\\\\r\\n\\u2028\\u2029]|\\\\(?:[^\\r\\n\\u2028\\u2029ux]|u[0-9A-Fa-f]{1,4}|x[0-9A-Fa-f]{2}))*+\\]";
    public static final String REGEXP = "^\\/(?![*/])(?:[^\\\\\\[/\\r\\n\\u2028\\u2029]|\\[(?:[^\\]\\\\\\r\\n\\u2028\\u2029]|\\\\(?:[^\\r\\n\\u2028\\u2029ux]|u[0-9A-Fa-f]{1,4}|x[0-9A-Fa-f]{2}))*+\\]|\\\\(?:[^\\r\\n\\u2028\\u2029ux]|u[0-9A-Fa-f]{1,4}|x[0-9A-Fa-f]{2}))*+\\/\\p{javaJavaIdentifierPart}*+";
    private final Channel<Lexer> delegate = RegexpChannelBuilder.regexp((TokenType)EcmaScriptTokenType.REGULAR_EXPRESSION_LITERAL, (String[])new String[]{"^\\/(?![*/])(?:[^\\\\\\[/\\r\\n\\u2028\\u2029]|\\[(?:[^\\]\\\\\\r\\n\\u2028\\u2029]|\\\\(?:[^\\r\\n\\u2028\\u2029ux]|u[0-9A-Fa-f]{1,4}|x[0-9A-Fa-f]{2}))*+\\]|\\\\(?:[^\\r\\n\\u2028\\u2029ux]|u[0-9A-Fa-f]{1,4}|x[0-9A-Fa-f]{2}))*+\\/\\p{javaJavaIdentifierPart}*+"});
    private static final Set<String> WHOLE_TOKENS = ImmutableSet.of((Object)"break", (Object)"case", (Object)"continue", (Object)"delete", (Object)"do", (Object)"else", (Object[])new String[]{"finally", "in", "instanceof", "return", "throw", "try", "typeof", "void", "+", "-", ".", "/", ",", "*"});
    private static final String[] ENDS = new String[]{"!", "%", "&", "(", ":", ";", "<", "=", ">", "?", "[", "^", "{", "|", "}", "~"};

    public boolean consume(CodeReader code, Lexer output) {
        Token lastToken;
        if (code.peek() == 47 && ((lastToken = EcmaScriptRegexpChannel.getLastToken(output)) == null || EcmaScriptRegexpChannel.guessNextIsRegexp(lastToken.getValue()))) {
            return this.delegate.consume(code, (Object)output);
        }
        return false;
    }

    private static Token getLastToken(Lexer output) {
        List tokens = output.getTokens();
        return tokens.isEmpty() ? null : (Token)tokens.get(tokens.size() - 1);
    }

    @VisibleForTesting
    static boolean guessNextIsRegexp(String preceder) {
        if (WHOLE_TOKENS.contains(preceder)) {
            return true;
        }
        for (String end : ENDS) {
            if (!preceder.endsWith(end)) continue;
            return true;
        }
        return false;
    }
}

