/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.unittest.jstestdriver;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.javascript.unittest.surefireparser.AbstractSurefireParser;

public class JsTestDriverSensor
implements Sensor {
    protected FileSystem fileSystem;
    protected Settings settings;
    private final FilePredicate mainFilePredicate;
    private final FilePredicate testFilePredicate;
    private static final Logger LOG = LoggerFactory.getLogger(JsTestDriverSensor.class);

    public JsTestDriverSensor(FileSystem fileSystem, Settings settings) {
        this.fileSystem = fileSystem;
        this.settings = settings;
        this.mainFilePredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguage("js"));
        this.testFilePredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.TEST), fileSystem.predicates().hasLanguage("js"));
    }

    public boolean shouldExecuteOnProject(Project project) {
        return StringUtils.isNotBlank((String)this.getReportsDirectoryPath()) && this.fileSystem.hasFiles(this.mainFilePredicate);
    }

    public void analyse(Project project, SensorContext context) {
        this.collect(context, this.getIOFile(this.getReportsDirectoryPath()));
    }

    protected void collect(final SensorContext context, File reportsDir) {
        LOG.info("Parsing Unit Test run results in Surefire format from folder {}", (Object)reportsDir);
        new AbstractSurefireParser(){

            @Override
            protected Resource getUnitTestResource(String classKey) {
                InputFile inputFile = JsTestDriverSensor.this.getTestFileRelativePathToBaseDir(JsTestDriverSensor.this.getUnitTestFileName(classKey));
                if (inputFile != null) {
                    return context.getResource((InputPath)inputFile);
                }
                LOG.warn("Test result will not be saved for test class \"{}\", because SonarQube associated resource has not been found using file name: \"{}\"", (Object)JsTestDriverSensor.this.getUnitTestClassName(classKey), (Object)JsTestDriverSensor.this.getUnitTestFileName(classKey));
                return null;
            }
        }.collect(context, reportsDir);
    }

    protected String getUnitTestFileName(String className) {
        String fileName = this.getUnitTestClassName(className);
        fileName = fileName.replace('.', '/');
        fileName = fileName + ".js";
        return fileName;
    }

    private String getUnitTestClassName(String classNameFromReport) {
        return classNameFromReport.substring(classNameFromReport.indexOf(46) + 1);
    }

    protected InputFile getTestFileRelativePathToBaseDir(String fileName) {
        for (InputFile inputFile : this.fileSystem.inputFiles(this.testFilePredicate)) {
            if (!inputFile.file().getAbsolutePath().endsWith(fileName)) continue;
            LOG.debug("Found potential test file corresponding to file name: {}", (Object)fileName);
            LOG.debug("Will fetch SonarQube associated resource with (logical) relative path to project base directory: {}", (Object)inputFile.relativePath());
            return inputFile;
        }
        return null;
    }

    protected File getIOFile(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.fileSystem.baseDir(), path);
        }
        return file;
    }

    protected String getReportsDirectoryPath() {
        return this.settings.getString("sonar.javascript.jstestdriver.reportsPath");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

