/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.matcher;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeSkippingPolicy;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.impl.ast.AlwaysSkipFromAst;
import com.sonar.sslr.impl.ast.NeverSkipFromAst;
import com.sonar.sslr.impl.ast.SkipFromAstIfOnlyOneChild;
import com.sonar.sslr.impl.matcher.GrammarFunctions;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.vm.CompilableGrammarRule;
import org.sonar.sslr.internal.vm.CompilationHandler;
import org.sonar.sslr.internal.vm.Instruction;
import org.sonar.sslr.internal.vm.MemoParsingExpression;
import org.sonar.sslr.internal.vm.ParsingExpression;
import org.sonar.sslr.internal.vm.RuleRefExpression;

public class RuleDefinition
implements Rule,
AstNodeSkippingPolicy,
GrammarRuleKey,
CompilableGrammarRule,
MemoParsingExpression {
    private final GrammarRuleKey ruleKey;
    private final String name;
    private ParsingExpression expression;
    private AstNodeType astNodeSkippingPolicy = NeverSkipFromAst.INSTANCE;
    private boolean memoize = false;

    public RuleDefinition(String name) {
        this.ruleKey = this;
        this.name = name;
    }

    public RuleDefinition(GrammarRuleKey ruleKey) {
        this.ruleKey = ruleKey;
        this.name = ruleKey.toString();
    }

    public String getName() {
        return this.name;
    }

    public RuleDefinition is(Object ... e) {
        this.throwExceptionIfRuleAlreadyDefined("The rule '" + this.ruleKey + "' has already been defined somewhere in the grammar.");
        this.throwExceptionIfEmptyListOfMatchers(e);
        this.setExpression(GrammarFunctions.convertToSingleExpression(e));
        return this;
    }

    public RuleDefinition override(Object ... e) {
        this.throwExceptionIfEmptyListOfMatchers(e);
        this.setExpression(GrammarFunctions.convertToSingleExpression(e));
        return this;
    }

    public void mock() {
        this.setExpression((ParsingExpression)GrammarFunctions.Standard.firstOf(this.getName(), this.getName().toUpperCase()));
    }

    public void skip() {
        this.astNodeSkippingPolicy = AlwaysSkipFromAst.INSTANCE;
    }

    public void skipIf(AstNodeSkippingPolicy astNodeSkipPolicy) {
        this.astNodeSkippingPolicy = astNodeSkipPolicy;
    }

    public void skipIfOneChild() {
        this.astNodeSkippingPolicy = SkipFromAstIfOnlyOneChild.INSTANCE;
    }

    private void throwExceptionIfRuleAlreadyDefined(String exceptionMessage) {
        if (this.getExpression() != null) {
            throw new IllegalStateException(exceptionMessage);
        }
    }

    private void throwExceptionIfEmptyListOfMatchers(Object[] matchers) {
        if (matchers.length == 0) {
            throw new IllegalStateException("The rule '" + this.ruleKey + "' should at least contains one matcher.");
        }
    }

    public void recoveryRule() {
    }

    public boolean hasToBeSkippedFromAst(AstNode node) {
        if (AstNodeSkippingPolicy.class.isAssignableFrom(this.astNodeSkippingPolicy.getClass())) {
            return ((AstNodeSkippingPolicy)this.astNodeSkippingPolicy).hasToBeSkippedFromAst(node);
        }
        return false;
    }

    public AstNodeType getRealAstNodeType() {
        return this.ruleKey;
    }

    public GrammarRuleKey getRuleKey() {
        return this.ruleKey;
    }

    public ParsingExpression getExpression() {
        return this.expression;
    }

    public void setExpression(ParsingExpression expression) {
        this.expression = expression;
    }

    public Instruction[] compile(CompilationHandler compiler) {
        return compiler.compile(new RuleRefExpression(this.getRuleKey()));
    }

    public String toString() {
        return this.getName();
    }

    public boolean shouldMemoize() {
        return this.memoize;
    }

    public void enableMemoization() {
        this.memoize = true;
    }
}

