/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.lexer;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.BlackHoleChannel;
import com.sonar.sslr.impl.channel.IdentifierAndKeywordChannel;
import com.sonar.sslr.impl.channel.PunctuatorChannel;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import com.sonar.sslr.impl.channel.UnknownCharacterChannel;
import org.sonar.javascript.EcmaScriptConfiguration;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.lexer.EcmaScriptRegexpChannel;

public final class EcmaScriptLexer {
    private static final String EXP = "([Ee][+-]?+[0-9_]++)";
    private static final String BINARY_EXP = "([Pp][+-]?+[0-9_]++)";
    private static final String FLOAT_SUFFIX = "[fFdD]";
    private static final String INT_SUFFIX = "[lL]";
    public static final String NUMERIC_LITERAL = "(?:[0-9]++\\.([0-9]++)?+([Ee][+-]?+[0-9_]++)?+[fFdD]?+|\\.[0-9]++([Ee][+-]?+[0-9_]++)?+[fFdD]?+|[0-9]++[fFdD]|[0-9]++([Ee][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++\\.[0-9a-fA-F_]*+([Pp][+-]?+[0-9_]++)?+[fFdD]?+|0[xX][0-9a-fA-F]++([Pp][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++[lL]?+|0[bB][01]++[lL]?+|[0-9]++[lL]?+)";
    public static final String LITERAL = "(?:\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"|'([^'\\\\]*+(\\\\[\\s\\S])?+)*+')";
    public static final String SINGLE_LINE_COMMENT = "//[^\\n\\r]*+|<!--[^\\n\\r]*+";
    public static final String MULTI_LINE_COMMENT = "/\\*[\\s\\S]*?\\*/";
    public static final String MULTI_LINE_COMMENT_NO_LB = "/\\*[^\\n\\r]*?\\*/";
    public static final String COMMENT = "(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[\\s\\S]*?\\*/)";
    private static final String HEX_DIGIT = "[0-9a-fA-F]";
    private static final String UNICODE_ESCAPE_SEQUENCE = "u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]";
    private static final String UNICODE_LETTER = "\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}";
    private static final String UNICODE_COMBINING_MARK = "\\p{Mn}\\p{Mc}";
    private static final String UNICODE_DIGIT = "\\p{Nd}";
    private static final String UNICODE_CONNECTOR_PUNCTUATION = "\\p{Pc}";
    private static final String IDENTIFIER_START = "(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])";
    private static final String IDENTIFIER_PART = "(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])";
    public static final String IDENTIFIER = "(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+";
    public static final String LINE_TERMINATOR = "\\n\\r\\u2028\\u2029";
    public static final String WHITESPACE = "\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}";

    private EcmaScriptLexer() {
    }

    public static Lexer create(EcmaScriptConfiguration conf) {
        return Lexer.builder().withCharset(conf.getCharset()).withFailIfNoChannelToConsumeOneCharacter(true).withChannel(new BlackHoleChannel("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]++")).withChannel(RegexpChannelBuilder.commentRegexp(COMMENT)).withChannel(RegexpChannelBuilder.regexp(GenericTokenType.LITERAL, LITERAL)).withChannel(new EcmaScriptRegexpChannel()).withChannel(RegexpChannelBuilder.regexp(EcmaScriptTokenType.NUMERIC_LITERAL, NUMERIC_LITERAL)).withChannel(new IdentifierAndKeywordChannel(IDENTIFIER, true, new TokenType[][]{EcmaScriptKeyword.values()})).withChannel(new PunctuatorChannel(EcmaScriptPunctuator.values())).withChannel(new UnknownCharacterChannel(true)).build();
    }
}

