/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.ast.select;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.Iterator;
import org.sonar.sslr.ast.AstSelect;
import org.sonar.sslr.internal.ast.select.AstSelectFactory;
import org.sonar.sslr.internal.ast.select.ListAstSelect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleAstSelect
implements AstSelect {
    private final AstNode node;

    public SingleAstSelect(AstNode node) {
        this.node = node;
    }

    @Override
    public AstSelect children() {
        if (this.node.getNumberOfChildren() == 1) {
            return new SingleAstSelect(this.node.getFirstChild());
        }
        if (this.node.getNumberOfChildren() > 1) {
            return new ListAstSelect(this.node.getChildren());
        }
        return AstSelectFactory.empty();
    }

    @Override
    public AstSelect children(AstNodeType type) {
        if (this.node.getNumberOfChildren() == 1) {
            AstNode result = this.node.getChildren().get(0);
            if (result.getType() == type) {
                return new SingleAstSelect(result);
            }
            return AstSelectFactory.empty();
        }
        if (this.node.getNumberOfChildren() > 1) {
            ArrayList<AstNode> result = Lists.newArrayList();
            for (AstNode child : this.node.getChildren()) {
                if (child.getType() != type) continue;
                result.add(child);
            }
            return AstSelectFactory.create(result);
        }
        return AstSelectFactory.empty();
    }

    @Override
    public AstSelect children(AstNodeType ... types) {
        if (this.node.getNumberOfChildren() == 1) {
            AstNode result = this.node.getChildren().get(0);
            if (result.is(types)) {
                return new SingleAstSelect(result);
            }
            return AstSelectFactory.empty();
        }
        if (this.node.getNumberOfChildren() > 1) {
            ArrayList<AstNode> result = Lists.newArrayList();
            for (AstNode child : this.node.getChildren()) {
                if (!child.is(types)) continue;
                result.add(child);
            }
            return AstSelectFactory.create(result);
        }
        return AstSelectFactory.empty();
    }

    @Override
    public AstSelect nextSibling() {
        return AstSelectFactory.select(this.node.getNextSibling());
    }

    @Override
    public AstSelect previousSibling() {
        return AstSelectFactory.select(this.node.getPreviousSibling());
    }

    @Override
    public AstSelect parent() {
        return AstSelectFactory.select(this.node.getParent());
    }

    @Override
    public AstSelect firstAncestor(AstNodeType type) {
        AstNode result;
        for (result = this.node.getParent(); result != null && result.getType() != type; result = result.getParent()) {
        }
        return AstSelectFactory.select(result);
    }

    @Override
    public AstSelect firstAncestor(AstNodeType ... types) {
        AstNode result;
        for (result = this.node.getParent(); result != null && !result.is(types); result = result.getParent()) {
        }
        return AstSelectFactory.select(result);
    }

    @Override
    public AstSelect descendants(AstNodeType type) {
        return AstSelectFactory.create(this.node.getDescendants(type));
    }

    @Override
    public AstSelect descendants(AstNodeType ... types) {
        return AstSelectFactory.create(this.node.getDescendants(types));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isNotEmpty() {
        return true;
    }

    @Override
    public AstSelect filter(AstNodeType type) {
        return this.node.getType() == type ? this : AstSelectFactory.empty();
    }

    @Override
    public AstSelect filter(AstNodeType ... types) {
        return this.node.is(types) ? this : AstSelectFactory.empty();
    }

    @Override
    public AstSelect filter(Predicate<AstNode> predicate) {
        return predicate.apply(this.node) ? this : AstSelectFactory.empty();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public AstNode get(int index) {
        if (index == 0) {
            return this.node;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Iterator<AstNode> iterator() {
        return Iterators.singletonIterator(this.node);
    }
}

