/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.toolkit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.xpath.api.AstNodeXPathQuery;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.sonar.sslr.internal.toolkit.SourceCodeModel;
import org.sonar.sslr.internal.toolkit.ToolkitView;
import org.sonar.sslr.toolkit.ConfigurationModel;
import org.sonar.sslr.toolkit.ConfigurationProperty;

public class ToolkitPresenter {
    private final ConfigurationModel configurationModel;
    private final SourceCodeModel model;
    private ToolkitView view = null;

    public ToolkitPresenter(ConfigurationModel configurationModel, SourceCodeModel model) {
        this.configurationModel = configurationModel;
        this.model = model;
    }

    public void setView(ToolkitView view) {
        Preconditions.checkNotNull(view);
        this.view = view;
    }

    @VisibleForTesting
    void checkInitialized() {
        Preconditions.checkState(this.view != null, "the view must be set before the presenter can be ran");
    }

    @VisibleForTesting
    void initUncaughtExceptionsHandler() {
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                e.printStackTrace(printWriter);
                ToolkitPresenter.this.view.appendToConsole(((Object)result).toString());
                ToolkitPresenter.this.view.setFocusOnConsoleView();
            }
        });
    }

    @VisibleForTesting
    void initConfigurationTab() {
        for (ConfigurationProperty configurationProperty : this.configurationModel.getProperties()) {
            this.view.addConfigurationProperty(configurationProperty.getName(), configurationProperty.getDescription());
            this.view.setConfigurationPropertyValue(configurationProperty.getName(), configurationProperty.getValue());
        }
    }

    public void run(String title) {
        this.checkInitialized();
        this.initUncaughtExceptionsHandler();
        this.view.setTitle(title);
        this.view.displayHighlightedSourceCode("");
        this.view.displayAst(null);
        this.view.displayXml("");
        this.view.disableXPathEvaluateButton();
        this.initConfigurationTab();
        this.view.run();
    }

    public void onSourceCodeOpenButtonClick() {
        File fileToParse = this.view.pickFileToParse();
        if (fileToParse != null) {
            this.view.clearConsole();
            try {
                this.view.displayHighlightedSourceCode(Files.toString(fileToParse, this.configurationModel.getCharset()));
            }
            catch (IOException e) {
                Throwables.propagate(e);
            }
            this.model.setSourceCode(fileToParse, this.configurationModel.getCharset());
            this.view.displayHighlightedSourceCode(this.model.getHighlightedSourceCode());
            this.view.displayAst(this.model.getAstNode());
            this.view.displayXml(this.model.getXml());
            this.view.scrollSourceCodeTo(new Point(0, 0));
            this.view.setFocusOnAbstractSyntaxTreeView();
            this.view.enableXPathEvaluateButton();
        }
    }

    public void onSourceCodeParseButtonClick() {
        this.view.clearConsole();
        String sourceCode = this.view.getSourceCode();
        this.model.setSourceCode(sourceCode);
        Point sourceCodeScrollbarPosition = this.view.getSourceCodeScrollbarPosition();
        this.view.displayHighlightedSourceCode(this.model.getHighlightedSourceCode());
        this.view.displayAst(this.model.getAstNode());
        this.view.displayXml(this.model.getXml());
        this.view.scrollSourceCodeTo(sourceCodeScrollbarPosition);
        this.view.setFocusOnAbstractSyntaxTreeView();
        this.view.enableXPathEvaluateButton();
    }

    public void onXPathEvaluateButtonClick() {
        String xpath = this.view.getXPath();
        AstNodeXPathQuery xpathQuery = AstNodeXPathQuery.create(xpath);
        this.view.clearConsole();
        this.view.clearAstSelections();
        this.view.clearSourceCodeHighlights();
        AstNode firstAstNode = null;
        for (Object resultObject : xpathQuery.selectNodes(this.model.getAstNode())) {
            if (!(resultObject instanceof AstNode)) continue;
            AstNode resultAstNode = (AstNode)resultObject;
            if (firstAstNode == null) {
                firstAstNode = resultAstNode;
            }
            this.view.selectAstNode(resultAstNode);
            this.view.highlightSourceCode(resultAstNode);
        }
        this.view.scrollAstTo(firstAstNode);
        this.view.scrollSourceCodeTo(firstAstNode);
        this.view.setFocusOnAbstractSyntaxTreeView();
    }

    public void onSourceCodeKeyTyped() {
        this.view.displayAst(null);
        this.view.displayXml("");
        this.view.clearSourceCodeHighlights();
        this.view.disableXPathEvaluateButton();
    }

    public void onSourceCodeTextCursorMoved() {
        this.view.clearAstSelections();
        AstNode astNode = this.view.getAstNodeFollowingCurrentSourceCodeTextCursorPosition();
        this.view.selectAstNode(astNode);
        this.view.scrollAstTo(astNode);
    }

    public void onAstSelectionChanged() {
        this.view.clearSourceCodeHighlights();
        AstNode firstAstNode = null;
        for (AstNode astNode : this.view.getSelectedAstNodes()) {
            if (firstAstNode == null) {
                firstAstNode = astNode;
            }
            this.view.highlightSourceCode(astNode);
        }
        this.view.scrollSourceCodeTo(firstAstNode);
    }

    public void onConfigurationPropertyFocusLost(String name) {
        ConfigurationProperty configurationProperty = this.getConfigurationPropertyByName(name);
        Preconditions.checkArgument(configurationProperty != null, "No such configuration property: " + name);
        String newValueCandidate = this.view.getConfigurationPropertyValue(name);
        String errorMessage = configurationProperty.validate(newValueCandidate);
        this.view.setConfigurationPropertyErrorMessage(configurationProperty.getName(), errorMessage);
        if ("".equals(errorMessage)) {
            configurationProperty.setValue(newValueCandidate);
            this.configurationModel.setUpdatedFlag();
        } else {
            this.view.setFocusOnConfigurationPropertyField(name);
            this.view.setFocusOnConfigurationView();
        }
    }

    private ConfigurationProperty getConfigurationPropertyByName(String name) {
        for (ConfigurationProperty configurationProperty : this.configurationModel.getProperties()) {
            if (!name.equals(configurationProperty.getName())) continue;
            return configurationProperty;
        }
        return null;
    }
}

