/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.util.ArrayList;
import java.util.List;
import org.sonar.sslr.internal.grammar.MutableParsingRule;
import org.sonar.sslr.internal.matchers.MatcherPathElement;
import org.sonar.sslr.internal.vm.Machine;
import org.sonar.sslr.internal.vm.MachineHandler;
import org.sonar.sslr.internal.vm.MachineStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorReportingHandler
implements MachineHandler {
    private final int errorIndex;
    private final List<List<MatcherPathElement>> failedPaths = Lists.newArrayList();

    public ErrorReportingHandler(int errorIndex) {
        this.errorIndex = errorIndex;
    }

    public List<List<MatcherPathElement>> getFailedPaths() {
        return this.failedPaths;
    }

    @Override
    public void onBacktrack(Machine machine) {
        List<MatcherPathElement> path;
        if (this.errorIndex == machine.getIndex() && this.isNewPath(path = ErrorReportingHandler.getPath(machine))) {
            this.failedPaths.add(path);
        }
    }

    private static List<MatcherPathElement> getPath(Machine machine) {
        ArrayList<MatcherPathElement> list = Lists.newArrayList();
        int endIndex = machine.getIndex();
        MachineStack stack = machine.peek();
        while (!stack.isEmpty()) {
            if (stack.matcher() instanceof MutableParsingRule || stack.matcher() instanceof RuleDefinition) {
                list.add(new MatcherPathElement(stack.matcher(), stack.index(), endIndex));
                endIndex = stack.index();
            }
            stack = stack.parent();
        }
        return ImmutableList.copyOf(Lists.reverse(list));
    }

    private boolean isNewPath(List<MatcherPathElement> path) {
        for (List<MatcherPathElement> old : Lists.reverse(this.failedPaths)) {
            if (!ErrorReportingHandler.isPrefix(path, old)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrefix(List<MatcherPathElement> first, List<MatcherPathElement> second) {
        if (first.size() > second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            if (first.get(i).equals(second.get(i))) continue;
            return false;
        }
        return true;
    }
}

