/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm.lexerful;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.util.ArrayList;
import java.util.List;
import org.sonar.sslr.internal.matchers.Matcher;
import org.sonar.sslr.internal.matchers.MatcherPathElement;
import org.sonar.sslr.internal.matchers.TextUtils;
import org.sonar.sslr.internal.vm.ErrorTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexerfulParseErrorFormatter {
    private static final int SNIPPET_SIZE = 30;
    private static final int EXCERPT_SIZE = 10;

    public String format(List<Token> tokens, int errorIndex, List<List<MatcherPathElement>> failedPaths) {
        StringBuilder sb = new StringBuilder();
        Pos errorPos = errorIndex < tokens.size() ? LexerfulParseErrorFormatter.getTokenStart(tokens.get(errorIndex)) : LexerfulParseErrorFormatter.getTokenEnd(tokens.get(tokens.size() - 1));
        sb.append("Parse error at line ").append(errorPos.line).append(" column ").append(errorPos.column);
        sb.append(" failed to match");
        if (failedPaths.size() > 1) {
            sb.append(" all of");
        }
        sb.append(':');
        for (List<MatcherPathElement> failedPath : failedPaths) {
            Matcher failedMatcher = Iterables.getLast(failedPath).getMatcher();
            sb.append(' ').append(((RuleDefinition)failedMatcher).getName());
        }
        sb.append('\n').append('\n');
        LexerfulParseErrorFormatter.appendSnippet(sb, tokens, errorIndex, errorPos.line);
        sb.append('\n');
        sb.append("Failed at rules:\n");
        ErrorTreeNode tree = ErrorTreeNode.buildTree(failedPaths);
        this.appendTree(sb, tokens, tree);
        return sb.toString();
    }

    private void appendTree(StringBuilder sb, List<Token> tokens, ErrorTreeNode node) {
        ArrayList<ErrorTreeNode> nodes = Lists.newArrayList();
        while (node.children.size() == 1) {
            nodes.add(node);
            node = node.children.get(0);
        }
        this.appendTree(sb, tokens, node, "", true);
        for (int i = nodes.size() - 1; i >= 0; --i) {
            LexerfulParseErrorFormatter.appendPathElement(sb, tokens, ((ErrorTreeNode)nodes.get((int)i)).pathElement);
        }
    }

    private void appendTree(StringBuilder sb, List<Token> tokens, ErrorTreeNode node, String prefix, boolean isTail) {
        boolean tail = true;
        for (int i = 0; i < node.children.size(); ++i) {
            this.appendTree(sb, tokens, node.children.get(i), prefix + (isTail ? "  " : "| "), tail);
            tail = false;
        }
        sb.append(prefix + (isTail ? "/-" : "+-"));
        LexerfulParseErrorFormatter.appendPathElement(sb, tokens, node.pathElement);
    }

    private static void appendPathElement(StringBuilder sb, List<Token> tokens, MatcherPathElement pathElement) {
        sb.append(((RuleDefinition)pathElement.getMatcher()).getName());
        if (pathElement.getStartIndex() != pathElement.getEndIndex()) {
            sb.append(" consumed from ").append(LexerfulParseErrorFormatter.getTokenStart(tokens.get(pathElement.getStartIndex()))).append(" to ").append(LexerfulParseErrorFormatter.getTokenEnd(tokens.get(pathElement.getEndIndex() - 1))).append(": ");
            int len = pathElement.getEndIndex() - pathElement.getStartIndex();
            if (len > 10) {
                len = 10;
                sb.append("...");
            }
            for (int i = pathElement.getEndIndex() - len; i < Math.min(pathElement.getEndIndex(), tokens.size()); ++i) {
                sb.append(' ');
                LexerfulParseErrorFormatter.appendEscapedToken(sb, tokens.get(i));
            }
        }
        sb.append('\n');
    }

    private static void appendEscapedToken(StringBuilder sb, Token token) {
        String value = token.getOriginalValue();
        for (int i = 0; i < value.length(); ++i) {
            sb.append(TextUtils.escape(value.charAt(i)));
        }
    }

    private static Pos getTokenStart(Token token) {
        Pos pos = new Pos();
        pos.line = token.getLine();
        pos.column = token.getColumn();
        return pos;
    }

    private static Pos getTokenEnd(Token token) {
        Pos pos = new Pos();
        pos.line = token.getLine();
        pos.column = token.getColumn();
        String[] tokenLines = token.getOriginalValue().split("(\r)?\n|\r", -1);
        if (tokenLines.length == 1) {
            pos.column += tokenLines[0].length();
        } else {
            pos.line += tokenLines.length - 1;
            pos.column = tokenLines[tokenLines.length - 1].length();
        }
        return pos;
    }

    @VisibleForTesting
    static void appendSnippet(StringBuilder sb, List<Token> tokens, int errorIndex, int errorLine) {
        int startToken = Math.max(errorIndex - 30, 0);
        int endToken = Math.min(errorIndex + 30, tokens.size());
        tokens = tokens.subList(startToken, endToken);
        int line = tokens.get(0).getLine();
        int column = tokens.get(0).getColumn();
        sb.append(LexerfulParseErrorFormatter.formatLineNumber(line, errorLine));
        for (Token token : tokens) {
            while (line < token.getLine()) {
                column = 0;
                sb.append('\n').append(LexerfulParseErrorFormatter.formatLineNumber(++line, errorLine));
            }
            while (column < token.getColumn()) {
                sb.append(' ');
                ++column;
            }
            String[] tokenLines = token.getOriginalValue().split("(\r)?\n|\r", -1);
            sb.append(tokenLines[0]);
            column += tokenLines[0].length();
            for (int j = 1; j < tokenLines.length; ++j) {
                sb.append('\n').append(LexerfulParseErrorFormatter.formatLineNumber(++line, errorLine)).append(tokenLines[j]);
                column = tokenLines[j].length();
            }
        }
        sb.append('\n');
    }

    private static String formatLineNumber(int line, int errorLine) {
        return line == errorLine ? String.format("%1$5s  ", "-->") : String.format("%1$5d: ", line);
    }

    private static class Pos {
        int line;
        int column;

        private Pos() {
        }

        public String toString() {
            return "(" + this.line + ", " + this.column + ")";
        }
    }
}

