/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="BackticksUsage", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class BackticksUsageCheck
extends SquidCheck<PythonGrammar> {
    private int prevLine = -1;

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonPunctuator.BACKTICK});
    }

    public void visitNode(AstNode astNode) {
        if (this.prevLine != astNode.getTokenLine()) {
            this.prevLine = astNode.getTokenLine();
            this.getContext().createLineViolation((CodeCheck)this, "Replace backticks by call to repr().", astNode, new Object[0]);
        }
    }
}

