/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonMetric;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.checks.ChecksHelper;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.squidbridge.measures.MetricDef;

@Rule(key="ClassComplexity", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ClassComplexityCheck
extends SquidCheck<Grammar> {
    private static final int DEFAULT_MAXIMUM_CLASS_COMPLEXITY_THRESHOLD = 80;
    @RuleProperty(key="maximumClassComplexityThreshold", defaultValue="80")
    private int maximumClassComplexityThreshold = 80;

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public void leaveNode(AstNode node) {
        SourceClass sourceClass = (SourceClass)this.getContext().peekSourceCode();
        int complexity = ChecksHelper.getRecursiveMeasureInt((SourceCode)sourceClass, (MetricDef)PythonMetric.COMPLEXITY);
        if (complexity > this.maximumClassComplexityThreshold) {
            this.getContext().createLineViolation((CodeCheck)this, "Class has a complexity of {0,number,integer} which is greater than {1,number,integer} authorized.", node, new Object[]{complexity, this.maximumClassComplexityThreshold});
        }
    }

    public void setMaximumClassComplexityThreshold(int threshold) {
        this.maximumClassComplexityThreshold = threshold;
    }
}

