/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.regex.Pattern;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

public abstract class AbstractFunctionNameCheck
extends SquidCheck<Grammar> {
    private static final String DEFAULT = "^[a-z_][a-z0-9_]{2,30}$";
    @RuleProperty(key="format", defaultValue="^[a-z_][a-z0-9_]{2,30}$")
    public String format = "^[a-z_][a-z0-9_]{2,30}$";
    private Pattern pattern = null;

    public void init() {
        this.pattern = Pattern.compile(this.format);
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF});
    }

    public void visitNode(AstNode astNode) {
        if (!this.shouldCheckFunctionDeclaration(astNode)) {
            return;
        }
        AstNode nameNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME});
        String name = nameNode.getTokenValue();
        if (!this.pattern.matcher(name).matches()) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename {0} \"{1}\" to match the regular expression {2}.", nameNode, new Object[]{this.typeName(), name, this.format});
        }
    }

    public abstract String typeName();

    public abstract boolean shouldCheckFunctionDeclaration(AstNode var1);
}

