/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api.symboltable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.AstVisitor;
import com.sonar.sslr.api.symboltable.SymbolTableBuilderContext;
import com.sonar.sslr.api.symboltable.SymbolTableBuilderVisitor;
import com.sonar.sslr.impl.ast.AstWalker;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolTableBuilder {
    private final List<SymbolTableBuilderVisitor> firstPhase = Lists.newArrayList();
    private final List<SymbolTableBuilderVisitor> secondPhase = Lists.newArrayList();

    public SymbolTableBuilder addToFirstPhase(SymbolTableBuilderVisitor symbolTableElementBuilder) {
        this.firstPhase.add(symbolTableElementBuilder);
        return this;
    }

    public SymbolTableBuilder addToSecondPhase(SymbolTableBuilderVisitor symbolTableElementBuilder) {
        this.secondPhase.add(symbolTableElementBuilder);
        return this;
    }

    public SymbolTableBuilderContext buildSymbolTable(AstNode astNode) {
        SymbolTableBuilderContext symbolTableBuilderContext = new SymbolTableBuilderContext();
        new AstWalker(SymbolTableBuilder.createVisitors(symbolTableBuilderContext, this.firstPhase)).walkAndVisit(astNode);
        new AstWalker(SymbolTableBuilder.createVisitors(symbolTableBuilderContext, this.secondPhase)).walkAndVisit(astNode);
        return symbolTableBuilderContext;
    }

    private static List<AstVisitor> createVisitors(SymbolTableBuilderContext symbolTableBuilderContext, List<SymbolTableBuilderVisitor> symbolTableElementBuilders) {
        ImmutableList.Builder visitors = ImmutableList.builder();
        for (SymbolTableBuilderVisitor symbolTableElementBuilder : symbolTableElementBuilders) {
            visitors.add(new AstVisitorForSymbolTable(symbolTableBuilderContext, symbolTableElementBuilder));
        }
        return visitors.build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AstVisitorForSymbolTable
    implements AstVisitor {
        private final SymbolTableBuilderVisitor symbolTableElementBuilder;
        private final SymbolTableBuilderContext symbolTableBuilderContext;

        public AstVisitorForSymbolTable(SymbolTableBuilderContext symbolTableBuilderContext, SymbolTableBuilderVisitor symbolTableElementBuilder) {
            this.symbolTableBuilderContext = symbolTableBuilderContext;
            this.symbolTableElementBuilder = symbolTableElementBuilder;
        }

        @Override
        public List<AstNodeType> getAstNodeTypesToVisit() {
            return this.symbolTableElementBuilder.getNodeTypes();
        }

        @Override
        public void visitFile(AstNode astNode) {
        }

        @Override
        public void leaveFile(AstNode astNode) {
        }

        @Override
        public void visitNode(AstNode astNode) {
            this.symbolTableElementBuilder.visitNode(this.symbolTableBuilderContext, astNode);
        }

        @Override
        public void leaveNode(AstNode astNode) {
        }
    }
}

