/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.matcher;

import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.matcher.AdjacentMatcher;
import com.sonar.sslr.impl.matcher.AndMatcher;
import com.sonar.sslr.impl.matcher.AnyTokenButNotMatcher;
import com.sonar.sslr.impl.matcher.AnyTokenMatcher;
import com.sonar.sslr.impl.matcher.BooleanMatcher;
import com.sonar.sslr.impl.matcher.BridgeMatcher;
import com.sonar.sslr.impl.matcher.ExclusiveTillMatcher;
import com.sonar.sslr.impl.matcher.InclusiveTillMatcher;
import com.sonar.sslr.impl.matcher.LongestOneMatcher;
import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.MemoMatcher;
import com.sonar.sslr.impl.matcher.NextMatcher;
import com.sonar.sslr.impl.matcher.NotMatcher;
import com.sonar.sslr.impl.matcher.OneToNMatcher;
import com.sonar.sslr.impl.matcher.OptMatcher;
import com.sonar.sslr.impl.matcher.OrMatcher;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import com.sonar.sslr.impl.matcher.TillNewLineMatcher;
import com.sonar.sslr.impl.matcher.TokenTypeClassMatcher;
import com.sonar.sslr.impl.matcher.TokenTypeMatcher;
import com.sonar.sslr.impl.matcher.TokenTypesMatcher;
import com.sonar.sslr.impl.matcher.TokenValueMatcher;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public final class GrammarFunctions {
    private static final String AT_LEAST_ONE_MATCHER_MESSAGE = "You must define at least one matcher.";
    private static final ThreadLocal<Map<Matcher, Matcher>> MATCHER_CACHE = new ThreadLocal<Map<Matcher, Matcher>>(){

        @Override
        protected Map<Matcher, Matcher> initialValue() {
            return new HashMap<Matcher, Matcher>();
        }
    };

    private static Matcher getCachedMatcher(Matcher matcher) {
        if (MATCHER_CACHE.get().containsKey(matcher)) {
            return MATCHER_CACHE.get().get(matcher);
        }
        MATCHER_CACHE.get().put(matcher, matcher);
        return matcher;
    }

    public static void resetCache() {
        MATCHER_CACHE.set(new HashMap());
    }

    private GrammarFunctions() {
    }

    public static void enableMemoizationOfMatchesForAllRules(Grammar grammar) {
        for (Field ruleField : Grammar.getAllRuleFields(grammar.getClass())) {
            RuleDefinition rule;
            String ruleName = ruleField.getName();
            try {
                rule = (RuleDefinition)ruleField.get(grammar);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to enable memoization for rule '" + ruleName + "'", e);
            }
            rule.getRule().memoizeMatches();
        }
    }

    protected static Matcher[] convertToMatchers(Object[] objects) {
        if (objects == null || objects.length == 0) {
            throw new IllegalStateException(AT_LEAST_ONE_MATCHER_MESSAGE);
        }
        Matcher[] matchers = new Matcher[objects.length];
        for (int i = 0; i < matchers.length; ++i) {
            matchers[i] = GrammarFunctions.convertToMatcher(objects[i]);
        }
        return matchers;
    }

    protected static Matcher convertToMatcher(Object object) {
        Matcher matcher;
        if (object == null) {
            throw new IllegalStateException("Null is not a valid matcher.");
        }
        if (object instanceof String) {
            matcher = GrammarFunctions.getCachedMatcher(new TokenValueMatcher((String)object));
        } else if (object instanceof TokenType) {
            TokenType tokenType = (TokenType)object;
            matcher = GrammarFunctions.getCachedMatcher(new TokenTypeMatcher(tokenType, tokenType.hasToBeSkippedFromAst(null)));
        } else if (object instanceof RuleDefinition) {
            matcher = ((RuleDefinition)object).getRule();
        } else if (object instanceof Class) {
            matcher = GrammarFunctions.getCachedMatcher(new TokenTypeClassMatcher((Class)object));
        } else if (object instanceof Matcher) {
            matcher = (Matcher)object;
        } else {
            throw new IllegalStateException("The matcher object can't be anything else than a Rule, Matcher, String, TokenType or Class. Object = " + object);
        }
        return matcher;
    }

    public static final class Advanced {
        private Advanced() {
        }

        public static Matcher adjacent(Object element) {
            return GrammarFunctions.getCachedMatcher(new AdjacentMatcher(GrammarFunctions.convertToMatcher(element)));
        }

        public static Matcher anyTokenButNot(Object element) {
            return GrammarFunctions.getCachedMatcher(new AnyTokenButNotMatcher(GrammarFunctions.convertToMatcher(element)));
        }

        public static Matcher isOneOfThem(TokenType ... types) {
            if (types == null || types.length == 0) {
                throw new IllegalStateException(GrammarFunctions.AT_LEAST_ONE_MATCHER_MESSAGE);
            }
            return GrammarFunctions.getCachedMatcher(new TokenTypesMatcher(types));
        }

        public static Matcher bridge(TokenType from, TokenType to) {
            return GrammarFunctions.getCachedMatcher(new BridgeMatcher(from, to));
        }

        public static Matcher isTrue() {
            return GrammarFunctions.getCachedMatcher(new BooleanMatcher(true));
        }

        public static Matcher isFalse() {
            return GrammarFunctions.getCachedMatcher(new BooleanMatcher(false));
        }

        public static Matcher anyToken() {
            return GrammarFunctions.getCachedMatcher(new AnyTokenMatcher());
        }

        public static Matcher tillNewLine() {
            return GrammarFunctions.getCachedMatcher(new TillNewLineMatcher());
        }

        public static Matcher till(Object element) {
            return GrammarFunctions.getCachedMatcher(new InclusiveTillMatcher(GrammarFunctions.convertToMatcher(element)));
        }

        public static Matcher exclusiveTill(Object ... elements) {
            return GrammarFunctions.getCachedMatcher(new ExclusiveTillMatcher(GrammarFunctions.convertToMatchers(elements)));
        }

        public static Matcher longestOne(Object ... elements) {
            return GrammarFunctions.getCachedMatcher(new LongestOneMatcher(GrammarFunctions.convertToMatchers(elements)));
        }

        public static Matcher memoizeMatches(Object element) {
            Matcher matcher = GrammarFunctions.convertToMatcher(element);
            return matcher instanceof MemoMatcher ? matcher : GrammarFunctions.getCachedMatcher(new MemoMatcher(matcher));
        }
    }

    public static final class Predicate {
        private Predicate() {
        }

        public static Matcher not(Object element) {
            return GrammarFunctions.getCachedMatcher(new NotMatcher(GrammarFunctions.convertToMatcher(element)));
        }

        public static Matcher next(Object ... elements) {
            return GrammarFunctions.getCachedMatcher(new NextMatcher(Standard.and(elements)));
        }
    }

    public static final class Standard {
        private Standard() {
        }

        public static Matcher o2n(Object ... objects) {
            return Standard.opt(Standard.one2n(objects));
        }

        public static Matcher one2n(Object ... elements) {
            return GrammarFunctions.getCachedMatcher(new OneToNMatcher(Standard.and(elements)));
        }

        public static Matcher opt(Object ... elements) {
            return GrammarFunctions.getCachedMatcher(new OptMatcher(Standard.and(elements)));
        }

        public static Matcher or(Object ... elements) {
            if (elements == null || elements.length == 0) {
                throw new IllegalStateException(GrammarFunctions.AT_LEAST_ONE_MATCHER_MESSAGE);
            }
            if (elements.length == 1) {
                return GrammarFunctions.convertToMatcher(elements[0]);
            }
            return GrammarFunctions.getCachedMatcher(new OrMatcher(GrammarFunctions.convertToMatchers(elements)));
        }

        public static Matcher and(Object ... elements) {
            if (elements == null || elements.length == 0) {
                throw new IllegalStateException(GrammarFunctions.AT_LEAST_ONE_MATCHER_MESSAGE);
            }
            if (elements.length == 1) {
                return GrammarFunctions.convertToMatcher(elements[0]);
            }
            return GrammarFunctions.getCachedMatcher(new AndMatcher(GrammarFunctions.convertToMatchers(elements)));
        }
    }
}

