/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.CommentAnalyser;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.squid.AstScanner;
import com.sonar.sslr.squid.SourceCodeBuilderCallback;
import com.sonar.sslr.squid.SourceCodeBuilderVisitor;
import com.sonar.sslr.squid.SquidAstVisitor;
import com.sonar.sslr.squid.SquidAstVisitorContextImpl;
import com.sonar.sslr.squid.metrics.CommentsVisitor;
import com.sonar.sslr.squid.metrics.ComplexityVisitor;
import com.sonar.sslr.squid.metrics.CounterVisitor;
import com.sonar.sslr.squid.metrics.LinesVisitor;
import java.io.File;
import java.util.Collection;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.PythonLinesOfCodeVisitor;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonMetric;
import org.sonar.python.parser.PythonParser;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceFunction;
import org.sonar.squid.api.SourceProject;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PythonAstScanner {
    private PythonAstScanner() {
    }

    public static SourceFile scanSingleFile(File file, SquidAstVisitor<PythonGrammar> ... visitors) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        AstScanner<PythonGrammar> scanner = PythonAstScanner.create(new PythonConfiguration(), visitors);
        scanner.scanFile(file);
        Collection sources = scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        if (sources.size() != 1) {
            throw new IllegalStateException("Only one SourceFile was expected whereas " + sources.size() + " has been returned.");
        }
        return (SourceFile)sources.iterator().next();
    }

    public static AstScanner<PythonGrammar> create(PythonConfiguration conf, SquidAstVisitor<PythonGrammar> ... visitors) {
        SquidAstVisitorContextImpl context = new SquidAstVisitorContextImpl(new SourceProject("Python Project"));
        final Parser<PythonGrammar> parser = PythonParser.create(conf, new ParsingEventListener[0]);
        AstScanner.Builder builder = AstScanner.builder((SquidAstVisitorContextImpl)context).setBaseParser(parser);
        builder.withMetrics((MetricDef[])PythonMetric.values());
        builder.setFilesMetric((MetricDef)PythonMetric.FILES);
        builder.setCommentAnalyser(new CommentAnalyser(){

            public boolean isBlank(String line) {
                for (int i = 0; i < line.length(); ++i) {
                    if (!Character.isLetterOrDigit(line.charAt(i))) continue;
                    return false;
                }
                return true;
            }

            public String getContents(String comment) {
                return comment.substring(comment.indexOf(35));
            }
        });
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                String functionName = astNode.findFirstChild(new AstNodeType[]{((PythonGrammar)parser.getGrammar()).funcname}).getChild(0).getTokenValue();
                SourceFunction function = new SourceFunction(functionName + ":" + astNode.getToken().getLine());
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }
        }, new AstNodeType[]{((PythonGrammar)parser.getGrammar()).funcdef}));
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)PythonMetric.FUNCTIONS).subscribeTo(new AstNodeType[]{((PythonGrammar)parser.getGrammar()).funcdef}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                String functionName = astNode.findFirstChild(new AstNodeType[]{((PythonGrammar)parser.getGrammar()).classname}).getChild(0).getTokenValue();
                SourceClass function = new SourceClass(functionName + ":" + astNode.getToken().getLine());
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }
        }, new AstNodeType[]{((PythonGrammar)parser.getGrammar()).classdef}));
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)PythonMetric.CLASSES).subscribeTo(new AstNodeType[]{((PythonGrammar)parser.getGrammar()).classdef}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesVisitor((MetricDef)PythonMetric.LINES));
        builder.withSquidAstVisitor(new PythonLinesOfCodeVisitor(PythonMetric.LINES_OF_CODE));
        builder.withSquidAstVisitor((SquidAstVisitor)CommentsVisitor.builder().withCommentMetric((MetricDef)PythonMetric.COMMENT_LINES).withBlankCommentMetric((MetricDef)PythonMetric.COMMENT_BLANK_LINES).withNoSonar(true).withIgnoreHeaderComment(conf.getIgnoreHeaderComments()).build());
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)PythonMetric.STATEMENTS).subscribeTo(new AstNodeType[]{((PythonGrammar)parser.getGrammar()).statement}).build());
        AstNodeType[] complexityAstNodeType = new AstNodeType[]{((PythonGrammar)parser.getGrammar()).funcdef, ((PythonGrammar)parser.getGrammar()).while_stmt, ((PythonGrammar)parser.getGrammar()).for_stmt, ((PythonGrammar)parser.getGrammar()).return_stmt, ((PythonGrammar)parser.getGrammar()).raise_stmt, ((PythonGrammar)parser.getGrammar()).except_clause, PythonKeyword.IF, PythonKeyword.AND, PythonKeyword.OR};
        builder.withSquidAstVisitor((SquidAstVisitor)ComplexityVisitor.builder().setMetricDef((MetricDef)PythonMetric.COMPLEXITY).subscribeTo(complexityAstNodeType).build());
        for (SquidAstVisitor<PythonGrammar> visitor : visitors) {
            builder.withSquidAstVisitor(visitor);
        }
        return builder.build();
    }
}

