/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.indexer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceCodeIndexer;
import org.sonar.squidbridge.api.SourceCodeSearchEngine;

public class SquidIndex
implements SourceCodeIndexer,
SourceCodeSearchEngine {
    private final Map<String, SourceCode> index = new TreeMap<String, SourceCode>();

    @Override
    public Collection<SourceCode> search(Query ... query) {
        HashSet<SourceCode> result = new HashSet<SourceCode>();
        for (SourceCode unit : this.index.values()) {
            if (!this.isSquidUnitMatchQueries(unit, query)) continue;
            result.add(unit);
        }
        return result;
    }

    private boolean isSquidUnitMatchQueries(SourceCode unit, Query ... queries) {
        for (Query query : queries) {
            boolean match = query.match(unit);
            if (match) continue;
            return false;
        }
        return true;
    }

    @Override
    public SourceCode search(String key) {
        return this.index.get(key);
    }

    @Override
    public void index(SourceCode sourceCode) {
        sourceCode.setSourceCodeIndexer(this);
        this.index.put(sourceCode.getKey(), sourceCode);
    }
}

