/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.bn.IDecoder;
import org.bn.annotations.ASN1Any;
import org.bn.annotations.ASN1BitString;
import org.bn.annotations.ASN1Boolean;
import org.bn.annotations.ASN1BoxedType;
import org.bn.annotations.ASN1Choice;
import org.bn.annotations.ASN1Element;
import org.bn.annotations.ASN1Enum;
import org.bn.annotations.ASN1EnumItem;
import org.bn.annotations.ASN1Integer;
import org.bn.annotations.ASN1Null;
import org.bn.annotations.ASN1ObjectIdentifier;
import org.bn.annotations.ASN1OctetString;
import org.bn.annotations.ASN1PreparedElement;
import org.bn.annotations.ASN1Real;
import org.bn.annotations.ASN1Sequence;
import org.bn.annotations.ASN1SequenceOf;
import org.bn.annotations.ASN1String;
import org.bn.coders.CoderUtils;
import org.bn.coders.DecodedObject;
import org.bn.coders.ElementInfo;
import org.bn.coders.IASN1PreparedElement;
import org.bn.coders.IASN1PreparedElementData;
import org.bn.coders.IASN1TypesDecoder;
import org.bn.metadata.ASN1ElementMetadata;
import org.bn.metadata.ASN1NullMetadata;
import org.bn.types.BitString;
import org.bn.types.ObjectIdentifier;

public abstract class Decoder
implements IDecoder,
IASN1TypesDecoder {
    @Override
    public <T> T decode(InputStream stream, Class<T> objectClass) throws Exception {
        ElementInfo elemInfo = new ElementInfo();
        elemInfo.setAnnotatedClass(objectClass);
        T objectInstance = objectClass.newInstance();
        if (objectInstance instanceof IASN1PreparedElement) {
            elemInfo.setPreparedInstance(objectInstance);
            return this.decodePreparedElement(this.decodeTag(stream), objectClass, elemInfo, stream).getValue();
        }
        elemInfo.setASN1ElementInfoForClass(objectClass);
        return this.decodeClassType(this.decodeTag(stream), objectClass, elemInfo, stream).getValue();
    }

    @Override
    public DecodedObject decodeClassType(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        if (objectClass.isAnnotationPresent(ASN1PreparedElement.class)) {
            return this.decodePreparedElement(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.hasPreparedInfo()) {
            return elementInfo.getPreparedInfo().getTypeMetadata().decode(this, decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1SequenceOf.class)) {
            return this.decodeSequenceOf(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Sequence.class)) {
            return this.decodeSequence(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Choice.class)) {
            return this.decodeChoice(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1BoxedType.class)) {
            return this.decodeBoxedType(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Enum.class)) {
            return this.decodeEnum(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Boolean.class)) {
            return this.decodeBoolean(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Any.class)) {
            return this.decodeAny(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Integer.class)) {
            return this.decodeInteger(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Real.class)) {
            return this.decodeReal(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1OctetString.class)) {
            return this.decodeOctetString(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1BitString.class) || elementInfo.getAnnotatedClass().equals(BitString.class)) {
            return this.decodeBitString(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1ObjectIdentifier.class) || elementInfo.getAnnotatedClass().equals(ObjectIdentifier.class)) {
            return this.decodeObjectIdentifier(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1String.class)) {
            return this.decodeString(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Null.class)) {
            return this.decodeNull(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Element.class)) {
            return this.decodeElement(decodedTag, objectClass, elementInfo, stream);
        }
        return this.decodeJavaElement(decodedTag, objectClass, elementInfo, stream);
    }

    protected DecodedObject decodeJavaElement(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        if (elementInfo.getAnnotatedClass().equals(String.class)) {
            return this.decodeString(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().equals(Integer.class)) {
            return this.decodeInteger(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().equals(Long.class)) {
            return this.decodeInteger(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().equals(Double.class)) {
            return this.decodeReal(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().equals(Boolean.class)) {
            return this.decodeBoolean(decodedTag, objectClass, elementInfo, stream);
        }
        if (elementInfo.getAnnotatedClass().equals(byte[].class)) {
            return this.decodeOctetString(decodedTag, objectClass, elementInfo, stream);
        }
        return null;
    }

    @Override
    public DecodedObject decodePreparedElement(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        IASN1PreparedElementData saveInfo = elementInfo.getPreparedInfo();
        IASN1PreparedElement preparedInstance = (IASN1PreparedElement)this.createInstanceForElement(objectClass, elementInfo);
        elementInfo.setPreparedInstance(preparedInstance);
        ASN1ElementMetadata elementDataSave = null;
        if (elementInfo.hasPreparedASN1ElementInfo()) {
            elementDataSave = elementInfo.getPreparedASN1ElementInfo();
        }
        elementInfo.setPreparedInfo(preparedInstance.getPreparedData());
        if (elementDataSave != null) {
            elementInfo.setPreparedASN1ElementInfo(elementDataSave);
        }
        DecodedObject result = preparedInstance.getPreparedData().getTypeMetadata().decode(this, decodedTag, objectClass, elementInfo, stream);
        elementInfo.setPreparedInfo(saveInfo);
        return result;
    }

    @Override
    public void invokeSetterMethodForField(Field field, Object object, Object param, ElementInfo elementInfo) throws Exception {
        if (elementInfo != null && elementInfo.hasPreparedInfo()) {
            elementInfo.getPreparedInfo().invokeSetterMethod(object, param);
        } else {
            Method method = CoderUtils.findSetterMethodForField(field, object.getClass(), param.getClass());
            method.invoke(object, param);
        }
    }

    @Override
    public void invokeSelectMethodForField(Field field, Object object, Object param, ElementInfo elementInfo) throws Exception {
        if (elementInfo != null && elementInfo.hasPreparedInfo()) {
            elementInfo.getPreparedInfo().invokeDoSelectMethod(object, param);
        } else {
            Method method = CoderUtils.findDoSelectMethodForField(field, object.getClass(), param.getClass());
            method.invoke(object, param);
        }
    }

    protected void initDefaultValues(Object object, ElementInfo elementInfo) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            if (object instanceof IASN1PreparedElement) {
                ((IASN1PreparedElement)object).initWithDefaults();
            } else {
                Method method = object.getClass().getMethod("initWithDefaults", null);
                if (method != null) {
                    method.invoke(object, (Object[])null);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected Object createInstanceForElement(Class objectClass, ElementInfo elementInfo) throws Exception {
        Object result = null;
        if (elementInfo.hasPreparedInstance()) {
            result = elementInfo.getPreparedInstance();
        } else if (elementInfo.hasPreparedInfo()) {
            if (elementInfo.getPreparedInfo().isMemberClass() && elementInfo.getParentObject() != null) {
                Constructor decl = objectClass.getDeclaredConstructor(elementInfo.getParentObject().getClass());
                result = decl.newInstance(elementInfo.getParentObject());
            } else {
                result = elementInfo.getPreparedInfo().newInstance();
            }
        } else if (objectClass.isMemberClass() && elementInfo.getParentObject() != null && !Modifier.isStatic(objectClass.getModifiers())) {
            Constructor decl = objectClass.getDeclaredConstructor(elementInfo.getParentObject().getClass());
            result = decl.newInstance(elementInfo.getParentObject());
        }
        if (result == null) {
            result = objectClass.newInstance();
        }
        return result;
    }

    @Override
    public DecodedObject decodeSequence(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        Object sequence = this.createInstanceForElement(objectClass, elementInfo);
        this.initDefaultValues(sequence, elementInfo);
        int maxSeqLen = elementInfo.getMaxAvailableLen();
        int curFieldIdx = 0;
        int sizeOfSequence = 0;
        DecodedObject fieldTag = null;
        Field[] fields = elementInfo.getFields(objectClass);
        if (maxSeqLen == -1 || maxSeqLen > 0) {
            fieldTag = this.decodeTag(stream);
            if (fieldTag != null) {
                sizeOfSequence += fieldTag.getSize();
            }
            for (curFieldIdx = 0; curFieldIdx < fields.length; ++curFieldIdx) {
                Field field = fields[curFieldIdx];
                DecodedObject obj = this.decodeSequenceField(fieldTag, sequence, curFieldIdx, field, stream, elementInfo, true);
                if (obj == null) continue;
                sizeOfSequence += obj.getSize();
                boolean isAny = false;
                if (curFieldIdx + 1 == fields.length - 1) {
                    ElementInfo info = new ElementInfo();
                    info.setAnnotatedClass(fields[curFieldIdx + 1]);
                    info.setMaxAvailableLen(elementInfo.getMaxAvailableLen());
                    info.setGenericInfo(field.getGenericType());
                    if (elementInfo.hasPreparedInfo()) {
                        info.setPreparedInfo(elementInfo.getPreparedInfo().getFieldMetadata(curFieldIdx + 1));
                    } else {
                        info.setASN1ElementInfoForClass(fields[curFieldIdx + 1]);
                    }
                    isAny = CoderUtils.isAnyField(fields[curFieldIdx + 1], info);
                }
                if (maxSeqLen != -1) {
                    elementInfo.setMaxAvailableLen(maxSeqLen - sizeOfSequence);
                }
                if (isAny || curFieldIdx >= fields.length - 1) continue;
                if (maxSeqLen == -1 || elementInfo.getMaxAvailableLen() > 0) {
                    fieldTag = this.decodeTag(stream);
                    if (fieldTag == null) break;
                    sizeOfSequence += fieldTag.getSize();
                    continue;
                }
                fieldTag = null;
            }
        }
        return new DecodedObject<Object>(sequence, sizeOfSequence);
    }

    protected ElementInfo createSequenceFieldInfo(ElementInfo elementInfo, Object sequenceObj, Field field, int fieldIdx) {
        ElementInfo info = new ElementInfo();
        info.setAnnotatedClass(field);
        info.setMaxAvailableLen(elementInfo.getMaxAvailableLen());
        info.setGenericInfo(field.getGenericType());
        if (elementInfo.hasPreparedInfo()) {
            info.setPreparedInfo(elementInfo.getPreparedInfo().getFieldMetadata(fieldIdx));
        } else {
            info.setASN1ElementInfoForClass(field);
        }
        if (CoderUtils.isMemberClass(field.getType(), info)) {
            info.setParentObject(sequenceObj);
        }
        return info;
    }

    protected DecodedObject decodeSequenceField(DecodedObject fieldTag, Object sequenceObj, int fieldIdx, Field field, InputStream stream, ElementInfo elementInfo, boolean optionalCheck) throws Exception {
        ElementInfo info = this.createSequenceFieldInfo(elementInfo, sequenceObj, field, fieldIdx);
        if (CoderUtils.isNullField(field, info)) {
            return this.decodeNull(fieldTag, field.getType(), info, stream);
        }
        DecodedObject value = this.decodeClassType(fieldTag, field.getType(), info, stream);
        if (value != null) {
            this.invokeSetterMethodForField(field, sequenceObj, value.getValue(), info);
        } else if (optionalCheck) {
            CoderUtils.checkForOptionalField(field, info);
        }
        return value;
    }

    @Override
    public DecodedObject decodeChoice(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        Object choice = this.createInstanceForElement(objectClass, elementInfo);
        DecodedObject value = null;
        Field[] fields = elementInfo.getFields(objectClass);
        int fieldIdx = 0;
        for (Field field : fields) {
            if (field.isSynthetic()) continue;
            ElementInfo info = new ElementInfo();
            info.setAnnotatedClass(field);
            if (elementInfo.hasPreparedInfo()) {
                info.setPreparedInfo(elementInfo.getPreparedInfo().getFieldMetadata(fieldIdx));
            } else {
                info.setASN1ElementInfoForClass(field);
            }
            if (CoderUtils.isMemberClass(field.getType(), info)) {
                info.setParentObject(choice);
            }
            info.setGenericInfo(field.getGenericType());
            value = this.decodeClassType(decodedTag, field.getType(), info, stream);
            ++fieldIdx;
            if (value == null) continue;
            this.invokeSelectMethodForField(field, choice, value.getValue(), info);
            break;
        }
        if (value == null && !CoderUtils.isOptional(elementInfo)) {
            throw new IllegalArgumentException("The choice '" + objectClass.toString() + "' does not have a selected item!");
        }
        return new DecodedObject<Object>(choice, value != null ? value.getSize() : 0);
    }

    @Override
    public DecodedObject decodeEnum(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        Field field = objectClass.getDeclaredField("value");
        Class<?> enumClass = null;
        for (Class<?> cls : objectClass.getDeclaredClasses()) {
            if (!cls.isEnum()) continue;
            enumClass = cls;
            break;
        }
        DecodedObject itemValue = this.decodeEnumItem(decodedTag, field.getType(), enumClass, elementInfo, stream);
        Field param = null;
        if (itemValue != null) {
            Object result = objectClass.newInstance();
            for (Field enumItem : enumClass.getDeclaredFields()) {
                ASN1EnumItem meta;
                if (!enumItem.isAnnotationPresent(ASN1EnumItem.class) || (meta = enumItem.getAnnotation(ASN1EnumItem.class)).tag() != ((Integer)itemValue.getValue()).intValue()) continue;
                param = enumItem;
                break;
            }
            this.invokeSetterMethodForField(field, result, param.get(null), null);
            return new DecodedObject(result, itemValue.getSize());
        }
        return null;
    }

    @Override
    public DecodedObject decodeElement(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        elementInfo.setAnnotatedClass(objectClass);
        return this.decodeClassType(decodedTag, objectClass, elementInfo, stream);
    }

    @Override
    public DecodedObject decodeBoxedType(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        Object resultObj = this.createInstanceForElement(objectClass, elementInfo);
        DecodedObject<Object> result = new DecodedObject<Object>(resultObj);
        Field field = null;
        field = elementInfo.hasPreparedInfo() ? elementInfo.getPreparedInfo().getValueField() : objectClass.getDeclaredField("value");
        elementInfo.setAnnotatedClass(field);
        elementInfo.setGenericInfo(field.getGenericType());
        if (CoderUtils.isMemberClass(field.getType(), elementInfo)) {
            elementInfo.setParentObject(resultObj);
        }
        boolean isNull = false;
        if (elementInfo.hasPreparedInfo()) {
            isNull = elementInfo.getPreparedInfo().getTypeMetadata() instanceof ASN1NullMetadata;
        } else {
            ASN1Element fieldInfo;
            isNull = field.isAnnotationPresent(ASN1Null.class);
            if (elementInfo.getASN1ElementInfo() == null) {
                elementInfo.setASN1ElementInfoForClass(field);
            } else if (!elementInfo.getASN1ElementInfo().hasTag() && (fieldInfo = field.getAnnotation(ASN1Element.class)) != null && fieldInfo.hasTag()) {
                ASN1ElementMetadata elData = new ASN1ElementMetadata(elementInfo.getASN1ElementInfo().name(), elementInfo.getASN1ElementInfo().isOptional(), fieldInfo.hasTag(), fieldInfo.isImplicitTag(), fieldInfo.tagClass(), fieldInfo.tag(), elementInfo.getASN1ElementInfo().hasDefaultValue());
                elementInfo.setPreparedASN1ElementInfo(elData);
            }
        }
        DecodedObject value = null;
        if (isNull) {
            value = this.decodeNull(decodedTag, field.getType(), elementInfo, stream);
        } else {
            value = this.decodeClassType(decodedTag, field.getType(), elementInfo, stream);
            if (value != null) {
                result.setSize(value.getSize());
                this.invokeSetterMethodForField(field, resultObj, value.getValue(), elementInfo);
            } else {
                result = null;
            }
        }
        return result;
    }
}

