/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders;

import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bn.IEncoder;
import org.bn.annotations.ASN1Any;
import org.bn.annotations.ASN1BitString;
import org.bn.annotations.ASN1Boolean;
import org.bn.annotations.ASN1BoxedType;
import org.bn.annotations.ASN1Choice;
import org.bn.annotations.ASN1Element;
import org.bn.annotations.ASN1Enum;
import org.bn.annotations.ASN1EnumItem;
import org.bn.annotations.ASN1Integer;
import org.bn.annotations.ASN1Null;
import org.bn.annotations.ASN1ObjectIdentifier;
import org.bn.annotations.ASN1OctetString;
import org.bn.annotations.ASN1Real;
import org.bn.annotations.ASN1Sequence;
import org.bn.annotations.ASN1SequenceOf;
import org.bn.annotations.ASN1String;
import org.bn.coders.CoderUtils;
import org.bn.coders.ElementInfo;
import org.bn.coders.IASN1PreparedElement;
import org.bn.coders.IASN1PreparedElementData;
import org.bn.coders.IASN1TypesEncoder;
import org.bn.metadata.ASN1ElementMetadata;
import org.bn.metadata.ASN1Metadata;
import org.bn.types.BitString;
import org.bn.types.ObjectIdentifier;

public abstract class Encoder<T>
implements IEncoder<T>,
IASN1TypesEncoder {
    @Override
    public void encode(T object, OutputStream stream) throws Exception {
        ElementInfo elemInfo = new ElementInfo();
        elemInfo.setAnnotatedClass(object.getClass());
        int sizeOfEncodedBytes = 0;
        if (object instanceof IASN1PreparedElement) {
            sizeOfEncodedBytes = this.encodePreparedElement(object, stream, elemInfo);
        } else {
            elemInfo.setASN1ElementInfoForClass(object.getClass());
            sizeOfEncodedBytes = this.encodeClassType(object, stream, elemInfo);
        }
        if (sizeOfEncodedBytes == 0) {
            throw new IllegalArgumentException("Unable to find any supported annotation for class type: " + object.getClass().toString());
        }
    }

    @Override
    public int encodeClassType(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        resultSize = elementInfo.hasPreparedInfo() ? (resultSize += elementInfo.getPreparedInfo().getTypeMetadata().encode(this, object, stream, elementInfo)) : (object instanceof IASN1PreparedElement ? (resultSize += this.encodePreparedElement(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1SequenceOf.class) ? (resultSize += this.encodeSequenceOf(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Sequence.class) ? (resultSize += this.encodeSequence(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Choice.class) ? (resultSize += this.encodeChoice(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1BoxedType.class) ? (resultSize += this.encodeBoxedType(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Enum.class) ? (resultSize += this.encodeEnum(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Boolean.class) ? (resultSize += this.encodeBoolean(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Any.class) ? (resultSize += this.encodeAny(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Integer.class) ? (resultSize += this.encodeInteger(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Real.class) ? (resultSize += this.encodeReal(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1OctetString.class) ? (resultSize += this.encodeOctetString(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1BitString.class) || object.getClass().equals(BitString.class) ? (resultSize += this.encodeBitString(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1ObjectIdentifier.class) || object.getClass().equals(ObjectIdentifier.class) ? (resultSize += this.encodeObjectIdentifier(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1String.class) ? (resultSize += this.encodeString(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Null.class) ? (resultSize += this.encodeNull(object, stream, elementInfo)) : (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1Element.class) ? (resultSize += this.encodeElement(object, stream, elementInfo)) : (resultSize += this.encodeJavaElement(object, stream, elementInfo))))))))))))))))));
        return resultSize;
    }

    protected int encodeJavaElement(Object object, OutputStream stream, ElementInfo info) throws Exception {
        if (object.getClass().equals(String.class)) {
            return this.encodeString(object, stream, info);
        }
        if (object.getClass().equals(Integer.class)) {
            return this.encodeInteger(object, stream, info);
        }
        if (object.getClass().equals(Long.class)) {
            return this.encodeInteger(object, stream, info);
        }
        if (object.getClass().equals(Double.class)) {
            return this.encodeReal(object, stream, info);
        }
        if (object.getClass().equals(Boolean.class)) {
            return this.encodeBoolean(object, stream, info);
        }
        if (object.getClass().isArray()) {
            return this.encodeOctetString(object, stream, info);
        }
        return 0;
    }

    @Override
    public int encodePreparedElement(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        IASN1PreparedElement preparedInstance = (IASN1PreparedElement)object;
        elementInfo.setPreparedInstance(preparedInstance);
        ASN1ElementMetadata elementDataSave = null;
        if (elementInfo.hasPreparedASN1ElementInfo()) {
            elementDataSave = elementInfo.getPreparedASN1ElementInfo();
        }
        elementInfo.setPreparedInfo(preparedInstance.getPreparedData());
        if (elementDataSave != null) {
            elementInfo.setPreparedASN1ElementInfo(elementDataSave);
        }
        IASN1PreparedElementData preparedInstanceData = preparedInstance.getPreparedData();
        ASN1Metadata metaData = preparedInstanceData.getTypeMetadata();
        return metaData.encode(this, object, stream, elementInfo);
    }

    @Override
    public Object invokeGetterMethodForField(Field field, Object object, ElementInfo elementInfo) throws Exception {
        if (elementInfo != null && elementInfo.hasPreparedInfo()) {
            return elementInfo.getPreparedInfo().invokeGetterMethod(object, null);
        }
        Method method = CoderUtils.findGetterMethodForField(field, object.getClass());
        return method.invoke(object, (Object[])null);
    }

    @Override
    public boolean invokeSelectedMethodForField(Field field, Object object, ElementInfo elementInfo) throws Exception {
        if (elementInfo != null && elementInfo.hasPreparedInfo()) {
            return (Boolean)elementInfo.getPreparedInfo().invokeIsSelectedMethod(object, null);
        }
        Method method = CoderUtils.findIsSelectedMethodForField(field, object.getClass());
        return (Boolean)method.invoke(object, (Object[])null);
    }

    @Override
    public int encodeSequence(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        Field[] fields = elementInfo.getFields(object.getClass());
        int fieldIdx = 0;
        for (Field field : fields) {
            resultSize += this.encodeSequenceField(object, fieldIdx++, field, stream, elementInfo);
        }
        return resultSize;
    }

    protected int encodeSequenceField(Object object, int fieldIdx, Field field, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        ElementInfo info = new ElementInfo();
        info.setAnnotatedClass(field);
        if (elementInfo.hasPreparedInfo()) {
            info.setPreparedInfo(elementInfo.getPreparedInfo().getFieldMetadata(fieldIdx));
        } else {
            info.setASN1ElementInfoForClass(field);
        }
        if (field.isSynthetic()) {
            return resultSize;
        }
        if (CoderUtils.isNullField(field, info)) {
            return this.encodeNull(object, stream, elementInfo);
        }
        Object invokeObjResult = this.invokeGetterMethodForField(field, object, info);
        if (invokeObjResult != null) {
            resultSize += this.encodeClassType(invokeObjResult, stream, info);
        } else {
            CoderUtils.checkForOptionalField(field, info);
        }
        return resultSize;
    }

    protected boolean isSelectedChoiceItem(Field field, Object object, ElementInfo info) throws Exception {
        return this.invokeSelectedMethodForField(field, object, info);
    }

    protected ElementInfo getChoiceSelectedElement(Object object, ElementInfo elementInfo) throws Exception {
        ElementInfo info = null;
        Field[] fields = elementInfo.getFields(object.getClass());
        int fieldIdx = 0;
        for (Field field : fields) {
            if (!field.isSynthetic()) {
                info = new ElementInfo();
                info.setAnnotatedClass(field);
                if (elementInfo.hasPreparedInfo()) {
                    info.setPreparedInfo(elementInfo.getPreparedInfo().getFieldMetadata(fieldIdx));
                } else {
                    info.setASN1ElementInfoForClass(field);
                }
                if (this.isSelectedChoiceItem(field, object, info)) break;
                info = null;
            }
            ++fieldIdx;
        }
        if (info == null) {
            throw new IllegalArgumentException("The choice '" + object.toString() + "' does not have a selected item!");
        }
        return info;
    }

    @Override
    public int encodeChoice(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        ElementInfo info = this.getChoiceSelectedElement(object, elementInfo);
        Object invokeObjResult = this.invokeGetterMethodForField((Field)info.getAnnotatedClass(), object, info);
        return resultSize += this.encodeClassType(invokeObjResult, stream, info);
    }

    @Override
    public int encodeEnum(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        Field field = object.getClass().getDeclaredField("value");
        Object result = this.invokeGetterMethodForField(field, object, null);
        Class<?> enumClass = null;
        for (Class<?> cls : object.getClass().getDeclaredClasses()) {
            if (!cls.isEnum()) continue;
            for (Field enumItem : cls.getDeclaredFields()) {
                if (!enumItem.isAnnotationPresent(ASN1EnumItem.class) || !enumItem.getName().equals(result.toString())) continue;
                elementInfo.setAnnotatedClass(enumItem);
                break;
            }
            enumClass = cls;
            break;
        }
        return resultSize += this.encodeEnumItem(result, enumClass, stream, elementInfo);
    }

    @Override
    public int encodeElement(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        elementInfo.setAnnotatedClass(object.getClass());
        return this.encodeClassType(object, stream, elementInfo);
    }

    @Override
    public int encodeBoxedType(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        ASN1Element fieldInfo;
        Field field = object.getClass().getDeclaredField("value");
        elementInfo.setAnnotatedClass(field);
        if (elementInfo.getASN1ElementInfo() == null) {
            elementInfo.setASN1ElementInfoForClass(field);
        } else if (!elementInfo.getASN1ElementInfo().hasTag() && (fieldInfo = field.getAnnotation(ASN1Element.class)) != null && fieldInfo.hasTag()) {
            ASN1ElementMetadata elData = new ASN1ElementMetadata(elementInfo.getASN1ElementInfo().name(), elementInfo.getASN1ElementInfo().isOptional(), fieldInfo.hasTag(), fieldInfo.isImplicitTag(), fieldInfo.tagClass(), fieldInfo.tag(), elementInfo.getASN1ElementInfo().hasDefaultValue());
            elementInfo.setPreparedASN1ElementInfo(elData);
        }
        if (field.isAnnotationPresent(ASN1Null.class)) {
            return this.encodeNull(object, stream, elementInfo);
        }
        return this.encodeClassType(this.invokeGetterMethodForField(field, object, elementInfo), stream, elementInfo);
    }
}

