/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders.ber;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import org.bn.annotations.ASN1EnumItem;
import org.bn.coders.CoderUtils;
import org.bn.coders.DecodedObject;
import org.bn.coders.ElementInfo;
import org.bn.coders.Encoder;
import org.bn.coders.ber.BERCoderUtils;
import org.bn.coders.ber.BERObjectIdentifier;
import org.bn.metadata.ASN1SequenceOfMetadata;
import org.bn.types.BitString;
import org.bn.types.ObjectIdentifier;
import org.bn.utils.ReverseByteArrayOutputStream;

public class BEREncoder<T>
extends Encoder<T> {
    @Override
    public void encode(T object, OutputStream stream) throws Exception {
        ReverseByteArrayOutputStream reverseStream = new ReverseByteArrayOutputStream();
        super.encode(object, reverseStream);
        reverseStream.writeTo(stream);
    }

    @Override
    public int encodeSequence(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        Field[] fields = elementInfo.getFields(object.getClass());
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[fields.length - 1 - i];
            resultSize += this.encodeSequenceField(object, fields.length - 1 - i, field, stream, elementInfo);
        }
        resultSize = !CoderUtils.isSequenceSet(elementInfo) ? (resultSize += this.encodeHeader(BERCoderUtils.getTagValueForElement(elementInfo, 0, 32, 16), resultSize, stream)) : (resultSize += this.encodeHeader(BERCoderUtils.getTagValueForElement(elementInfo, 0, 32, 17), resultSize, stream));
        return resultSize;
    }

    @Override
    public int encodeChoice(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        int sizeOfChoiceField = super.encodeChoice(object, stream, elementInfo);
        if (elementInfo.hasPreparedInfo() && elementInfo.hasPreparedASN1ElementInfo() && elementInfo.getPreparedASN1ElementInfo().hasTag() || elementInfo.getASN1ElementInfo() != null && elementInfo.getASN1ElementInfo().hasTag()) {
            resultSize += this.encodeHeader(BERCoderUtils.getTagValueForElement(elementInfo, 128, 32, 31), sizeOfChoiceField, stream);
        }
        return resultSize += sizeOfChoiceField;
    }

    @Override
    public int encodeEnumItem(Object enumConstant, Class enumClass, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        ASN1EnumItem enumObj = elementInfo.getAnnotatedClass().getAnnotation(ASN1EnumItem.class);
        int szOfInt = this.encodeIntegerValue(enumObj.tag(), stream);
        resultSize += szOfInt;
        resultSize += this.encodeLength(szOfInt, stream);
        return resultSize += this.encodeTag(BERCoderUtils.getTagValueForElement(elementInfo, 0, 0, 10), stream);
    }

    @Override
    public int encodeBoolean(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 1;
        stream.write((Boolean)object != false ? 255 : 0);
        resultSize += this.encodeLength(1, stream);
        return resultSize += this.encodeTag(BERCoderUtils.getTagValueForElement(elementInfo, 0, 0, 1), stream);
    }

    @Override
    public int encodeAny(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        int sizeOfString = 0;
        byte[] buffer = (byte[])object;
        stream.write(buffer);
        sizeOfString = buffer.length;
        CoderUtils.checkConstraints(sizeOfString, elementInfo);
        return resultSize += sizeOfString;
    }

    public int encodeIntegerValue(long value, OutputStream stream) throws Exception {
        int resultSize = CoderUtils.getIntegerLength(value);
        for (int i = 0; i < resultSize; ++i) {
            stream.write((byte)value);
            value >>= 8;
        }
        return resultSize;
    }

    @Override
    public int encodeInteger(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        int szOfInt = 0;
        if (object instanceof Integer) {
            Integer value = (Integer)object;
            CoderUtils.checkConstraints(value.intValue(), elementInfo);
            szOfInt = this.encodeIntegerValue(value.intValue(), stream);
        } else if (object instanceof Long) {
            Long value = (Long)object;
            CoderUtils.checkConstraints(value, elementInfo);
            szOfInt = this.encodeIntegerValue(value, stream);
        }
        resultSize += szOfInt;
        resultSize += this.encodeLength(szOfInt, stream);
        return resultSize += this.encodeTag(BERCoderUtils.getTagValueForElement(elementInfo, 0, 0, 2), stream);
    }

    @Override
    public int encodeReal(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        Double value = (Double)object;
        int szOfInt = 0;
        long asLong = Double.doubleToLongBits(value);
        if (asLong == 0x7FF0000000000000L) {
            stream.write(64);
        } else if (asLong == -4503599627370496L) {
            stream.write(65);
        } else if (asLong != 0L) {
            long exponent = ((0x7FF0000000000000L & asLong) >> 52) - 1023L - 52L;
            long mantissa = 0xFFFFFFFFFFFFFL & asLong;
            mantissa |= 0x10000000000000L;
            while ((mantissa & 0xFFL) == 0L) {
                mantissa >>= 8;
                exponent += 8L;
            }
            while ((mantissa & 1L) == 0L) {
                mantissa >>= 1;
                ++exponent;
            }
            szOfInt += this.encodeIntegerValue(mantissa, stream);
            int szOfExp = CoderUtils.getIntegerLength(exponent);
            szOfInt += this.encodeIntegerValue(exponent, stream);
            int realPreamble = 128;
            realPreamble |= (byte)(szOfExp - 1);
            if ((asLong & Long.MIN_VALUE) == 1L) {
                realPreamble |= 0x40;
            }
            stream.write(realPreamble);
            ++szOfInt;
        }
        resultSize += szOfInt;
        resultSize += this.encodeLength(szOfInt, stream);
        return resultSize += this.encodeTag(BERCoderUtils.getTagValueForElement(elementInfo, 0, 0, 9), stream);
    }

    @Override
    public int encodeOctetString(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        int sizeOfString = 0;
        byte[] buffer = (byte[])object;
        stream.write(buffer);
        sizeOfString = buffer.length;
        resultSize += sizeOfString;
        CoderUtils.checkConstraints(sizeOfString, elementInfo);
        resultSize += this.encodeLength(sizeOfString, stream);
        return resultSize += this.encodeTag(BERCoderUtils.getTagValueForElement(elementInfo, 0, 0, 4), stream);
    }

    @Override
    public int encodeBitString(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        int sizeOfString = 0;
        BitString str = (BitString)object;
        CoderUtils.checkConstraints(str.getLengthInBits(), elementInfo);
        byte[] buffer = str.getValue();
        stream.write(buffer);
        stream.write(str.getTrailBitsCnt());
        sizeOfString = buffer.length + 1;
        resultSize += sizeOfString;
        resultSize += this.encodeLength(sizeOfString, stream);
        return resultSize += this.encodeTag(BERCoderUtils.getTagValueForElement(elementInfo, 0, 0, 3), stream);
    }

    @Override
    public int encodeString(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        int sizeOfString = 0;
        byte[] strBuf = CoderUtils.ASN1StringToBuffer(object, elementInfo);
        stream.write(strBuf);
        sizeOfString = strBuf.length;
        resultSize += sizeOfString;
        CoderUtils.checkConstraints(sizeOfString, elementInfo);
        resultSize += this.encodeLength(sizeOfString, stream);
        return resultSize += this.encodeTag(BERCoderUtils.getTagValueForElement(elementInfo, 0, 0, CoderUtils.getStringTagForElement(elementInfo)), stream);
    }

    @Override
    public int encodeSequenceOf(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        Object[] collection = ((Collection)object).toArray();
        int sizeOfCollection = 0;
        for (int i = 0; i < collection.length; ++i) {
            Object obj = collection[collection.length - 1 - i];
            ElementInfo info = new ElementInfo();
            info.setAnnotatedClass(obj.getClass());
            info.setParentAnnotated(elementInfo.getAnnotatedClass());
            if (elementInfo.hasPreparedInfo()) {
                ASN1SequenceOfMetadata seqOfMeta = (ASN1SequenceOfMetadata)elementInfo.getPreparedInfo().getTypeMetadata();
                info.setPreparedInfo(seqOfMeta.getItemClassMetadata());
            }
            sizeOfCollection += this.encodeClassType(obj, stream, info);
        }
        resultSize += sizeOfCollection;
        CoderUtils.checkConstraints(collection.length, elementInfo);
        resultSize += this.encodeLength(sizeOfCollection, stream);
        resultSize = !CoderUtils.isSequenceSetOf(elementInfo) ? (resultSize += this.encodeTag(BERCoderUtils.getTagValueForElement(elementInfo, 0, 32, 16), stream)) : (resultSize += this.encodeTag(BERCoderUtils.getTagValueForElement(elementInfo, 0, 32, 17), stream));
        return resultSize;
    }

    protected int encodeHeader(DecodedObject<Integer> tagValue, int contentLen, OutputStream stream) throws Exception {
        int resultSize = this.encodeLength(contentLen, stream);
        return resultSize += this.encodeTag(tagValue, stream);
    }

    protected int encodeTag(DecodedObject<Integer> tagValue, OutputStream stream) throws Exception {
        int resultSize = tagValue.getSize();
        int value = tagValue.getValue();
        for (int i = 0; i < tagValue.getSize(); ++i) {
            stream.write((byte)value);
            value >>= 8;
        }
        return resultSize;
    }

    protected int encodeLength(int length, OutputStream stream) throws IOException {
        int resultSize = 0;
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (length < 128) {
            stream.write(length);
            ++resultSize;
        } else if (length < 256) {
            stream.write(length);
            stream.write(-127);
            resultSize += 2;
        } else if (length < 65536) {
            stream.write((byte)length);
            stream.write((byte)(length >> 8));
            stream.write(-126);
            resultSize += 3;
        } else if (length < 0xFFFFA6) {
            stream.write((byte)length);
            stream.write((byte)(length >> 8));
            stream.write((byte)(length >> 16));
            stream.write(-125);
            resultSize += 4;
        } else {
            stream.write((byte)length);
            stream.write((byte)(length >> 8));
            stream.write((byte)(length >> 16));
            stream.write((byte)(length >> 24));
            stream.write(-124);
            resultSize += 5;
        }
        return resultSize;
    }

    @Override
    public int encodeNull(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        stream.write(0);
        int resultSize = 1;
        return resultSize += this.encodeTag(BERCoderUtils.getTagValueForElement(elementInfo, 0, 0, 5), stream);
    }

    @Override
    public int encodeObjectIdentifier(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        ObjectIdentifier oid = (ObjectIdentifier)object;
        int[] ia = oid.getIntArray();
        byte[] buffer = BERObjectIdentifier.Encode(ia);
        stream.write(buffer, 0, buffer.length);
        int resultSize = buffer.length;
        resultSize += this.encodeLength(resultSize, stream);
        return resultSize += this.encodeTag(BERCoderUtils.getTagValueForElement(elementInfo, 0, 0, 6), stream);
    }
}

