/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders.per;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.SortedMap;
import org.bn.annotations.ASN1EnumItem;
import org.bn.annotations.constraints.ASN1SizeConstraint;
import org.bn.annotations.constraints.ASN1ValueRangeConstraint;
import org.bn.coders.CoderUtils;
import org.bn.coders.DecodedObject;
import org.bn.coders.Decoder;
import org.bn.coders.ElementInfo;
import org.bn.coders.ber.BERObjectIdentifier;
import org.bn.coders.per.PERCoderUtils;
import org.bn.metadata.ASN1SequenceOfMetadata;
import org.bn.metadata.constraints.ASN1SizeConstraintMetadata;
import org.bn.metadata.constraints.ASN1ValueRangeConstraintMetadata;
import org.bn.metadata.constraints.IASN1ConstraintMetadata;
import org.bn.types.BitString;
import org.bn.types.ObjectIdentifier;
import org.bn.utils.BitArrayInputStream;

public class PERAlignedDecoder
extends Decoder {
    @Override
    public <T> T decode(InputStream stream, Class<T> objectClass) throws Exception {
        return super.decode(new BitArrayInputStream(stream), objectClass);
    }

    @Override
    public DecodedObject decodeTag(InputStream stream) throws Exception {
        return null;
    }

    protected void skipAlignedBits(InputStream stream) {
        ((BitArrayInputStream)stream).skipUnreadedBits();
    }

    protected long decodeIntegerValueAsBytes(int intLen, InputStream stream) throws Exception {
        long value = 0L;
        for (int i = 0; i < intLen; ++i) {
            int bt = stream.read();
            if (bt == -1) {
                throw new IllegalArgumentException("Unexpected EOF when decoding!");
            }
            if (i == 0 && (bt & 0xFFFFFF80) != 0) {
                bt -= 256;
            }
            value = value << 8 | (long)bt;
        }
        return value;
    }

    protected int decodeConstraintLengthDeterminant(int min, int max, BitArrayInputStream stream) throws Exception {
        if (max <= 65535) {
            return (int)this.decodeConstraintNumber(min, max, stream);
        }
        return this.decodeLengthDeterminant(stream);
    }

    protected int decodeLengthDeterminant(BitArrayInputStream stream) throws IOException {
        this.skipAlignedBits(stream);
        int result = stream.read();
        if ((result & 0x80) == 0) {
            return result;
        }
        result = (result & 0x3F) << 8;
        return result |= stream.read();
    }

    protected long decodeConstraintNumber(long min, long max, BitArrayInputStream stream) throws Exception {
        long result = 0L;
        long valueRange = max - min;
        int maxBitLen = PERCoderUtils.getMaxBitLength(valueRange);
        if (valueRange == 0L) {
            return max;
        }
        if (valueRange > 0L && valueRange < 256L) {
            this.skipAlignedBits(stream);
            result = stream.readBits(maxBitLen);
            result += min;
        } else if (valueRange > 0L && valueRange < 65536L) {
            this.skipAlignedBits(stream);
            result = stream.read() << 8;
            result |= (long)stream.read();
            result += min;
        } else {
            int intLen = this.decodeConstraintLengthDeterminant(1, CoderUtils.getPositiveIntegerLength(valueRange), stream);
            this.skipAlignedBits(stream);
            result = (int)this.decodeIntegerValueAsBytes(intLen, stream);
            result += min;
        }
        return result;
    }

    protected int decodeSemiConstraintNumber(int min, BitArrayInputStream stream) throws Exception {
        int result = 0;
        int intLen = this.decodeLengthDeterminant(stream);
        this.skipAlignedBits(stream);
        result = (int)this.decodeIntegerValueAsBytes(intLen, stream);
        return result += min;
    }

    protected int decodeNormallySmallNumber(BitArrayInputStream stream) throws Exception {
        int result = 0;
        int bitIndicator = stream.readBit();
        result = bitIndicator == 0 ? stream.readBits(6) : this.decodeSemiConstraintNumber(0, stream);
        return result;
    }

    protected int decodeUnconstraintNumber(BitArrayInputStream stream) throws Exception {
        int result = 0;
        int numLen = this.decodeLengthDeterminant(stream);
        this.skipAlignedBits(stream);
        return result += (int)this.decodeIntegerValueAsBytes(numLen, stream);
    }

    protected int decodeLength(ElementInfo elementInfo, InputStream stream) throws Exception {
        int result = 0;
        BitArrayInputStream bitStream = (BitArrayInputStream)stream;
        if (elementInfo.hasPreparedInfo()) {
            if (elementInfo.getPreparedInfo().hasConstraint()) {
                IASN1ConstraintMetadata constraint = elementInfo.getPreparedInfo().getConstraint();
                if (constraint instanceof ASN1ValueRangeConstraintMetadata) {
                    result = this.decodeConstraintLengthDeterminant((int)((ASN1ValueRangeConstraintMetadata)constraint).getMin(), (int)((ASN1ValueRangeConstraintMetadata)constraint).getMax(), bitStream);
                } else if (constraint instanceof ASN1SizeConstraintMetadata) {
                    result = (int)((ASN1SizeConstraintMetadata)constraint).getMax();
                }
            } else {
                result = this.decodeLengthDeterminant(bitStream);
            }
        } else if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1ValueRangeConstraint.class)) {
            ASN1ValueRangeConstraint constraint = elementInfo.getAnnotatedClass().getAnnotation(ASN1ValueRangeConstraint.class);
            result = this.decodeConstraintLengthDeterminant((int)constraint.min(), (int)constraint.max(), bitStream);
        } else if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1SizeConstraint.class)) {
            ASN1SizeConstraint constraint = elementInfo.getAnnotatedClass().getAnnotation(ASN1SizeConstraint.class);
            result = (int)constraint.max();
        } else {
            result = this.decodeLengthDeterminant(bitStream);
        }
        CoderUtils.checkConstraints(result, elementInfo);
        return result;
    }

    @Override
    public DecodedObject decodeChoice(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        Object choice = this.createInstanceForElement(objectClass, elementInfo);
        this.skipAlignedBits(stream);
        Field[] fields = null;
        fields = elementInfo.hasPreparedInfo() ? elementInfo.getPreparedInfo().getFields() : PERCoderUtils.getRealFields(objectClass).toArray(new Field[0]);
        int elementIndex = (int)this.decodeConstraintNumber(1L, fields.length, (BitArrayInputStream)stream);
        DecodedObject value = null;
        for (int i = 0; i < elementIndex && i < fields.length; ++i) {
            if (i + 1 != elementIndex) continue;
            Field field = fields[i];
            ElementInfo info = new ElementInfo();
            info.setAnnotatedClass(field);
            if (elementInfo.hasPreparedInfo()) {
                info.setPreparedInfo(elementInfo.getPreparedInfo().getFieldMetadata(i));
            } else {
                info.setASN1ElementInfoForClass(field);
            }
            info.setGenericInfo(field.getGenericType());
            value = this.decodeClassType(decodedTag, field.getType(), info, stream);
            this.invokeSelectMethodForField(field, choice, value.getValue(), info);
            break;
        }
        if (value == null && !CoderUtils.isOptional(elementInfo)) {
            throw new IllegalArgumentException("The choice '" + objectClass.toString() + "' does not have a selected item!");
        }
        return new DecodedObject<Object>(choice);
    }

    protected int getSequencePreambleBitLen(Class objectClass, ElementInfo elementInfo) throws Exception {
        int preambleLen = 0;
        ElementInfo info = new ElementInfo();
        int fieldIdx = 0;
        for (Field field : elementInfo.getFields(objectClass)) {
            if (field.isSynthetic()) continue;
            if (elementInfo.hasPreparedInfo()) {
                info.setPreparedInfo(elementInfo.getPreparedInfo().getFieldMetadata(fieldIdx));
            }
            if (CoderUtils.isOptionalField(field, info)) {
                ++preambleLen;
            }
            ++fieldIdx;
        }
        return preambleLen;
    }

    @Override
    public DecodedObject decodeSequence(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        BitArrayInputStream bitStream = (BitArrayInputStream)stream;
        int preambleLen = this.getSequencePreambleBitLen(objectClass, elementInfo);
        int preamble = bitStream.readBits(preambleLen);
        int preambleCurrentBit = 32 - preambleLen;
        this.skipAlignedBits(stream);
        Object sequence = this.createInstanceForElement(objectClass, elementInfo);
        this.initDefaultValues(sequence, elementInfo);
        Field[] fields = null;
        if (!CoderUtils.isSequenceSet(elementInfo) || elementInfo.hasPreparedInfo()) {
            fields = elementInfo.getFields(objectClass);
        } else {
            SortedMap<Integer, Field> fieldOrder = CoderUtils.getSetOrder(objectClass);
            fields = new Field[]{};
            fields = fieldOrder.values().toArray(fields);
        }
        int idx = 0;
        ElementInfo info = new ElementInfo();
        for (Field field : fields) {
            if (field.isSynthetic()) continue;
            if (elementInfo.hasPreparedInfo()) {
                info.setPreparedInfo(elementInfo.getPreparedInfo().getFieldMetadata(idx));
            }
            if (CoderUtils.isOptionalField(field, info)) {
                if ((preamble & Integer.MIN_VALUE >>> preambleCurrentBit) != 0) {
                    this.decodeSequenceField(null, sequence, idx, field, stream, elementInfo, true);
                }
                ++preambleCurrentBit;
            } else {
                this.decodeSequenceField(null, sequence, idx, field, stream, elementInfo, true);
            }
            ++idx;
        }
        return new DecodedObject<Object>(sequence);
    }

    @Override
    public DecodedObject decodeEnumItem(DecodedObject decodedTag, Class objectClass, Class enumClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        int min = 0;
        int max = 0;
        for (Field enumItem : enumClass.getDeclaredFields()) {
            if (!enumItem.isAnnotationPresent(ASN1EnumItem.class)) continue;
            ++max;
        }
        if (max <= 0) {
            throw new Exception("Unable to present any enum item!");
        }
        int enumItemIdx = (int)this.decodeConstraintNumber(min, max - 1, (BitArrayInputStream)stream);
        DecodedObject<Integer> result = new DecodedObject<Integer>();
        int idx = 0;
        for (Field enumItem : enumClass.getDeclaredFields()) {
            if (!enumItem.isAnnotationPresent(ASN1EnumItem.class) || idx++ != enumItemIdx) continue;
            ASN1EnumItem enumItemObj = enumItem.getAnnotation(ASN1EnumItem.class);
            result.setValue(enumItemObj.tag());
            break;
        }
        return result;
    }

    @Override
    public DecodedObject decodeBoolean(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        DecodedObject<Boolean> result = new DecodedObject<Boolean>();
        BitArrayInputStream bitStream = (BitArrayInputStream)stream;
        result.setValue(bitStream.readBit() == 1);
        return result;
    }

    @Override
    public DecodedObject decodeAny(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        return null;
    }

    @Override
    public DecodedObject decodeNull(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        return new DecodedObject(objectClass.newInstance());
    }

    @Override
    public DecodedObject decodeInteger(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        DecodedObject<Number> result;
        Object constraint;
        boolean hasConstraint = false;
        long min = 0L;
        long max = 0L;
        if (elementInfo.hasPreparedInfo()) {
            if (elementInfo.getPreparedInfo().hasConstraint() && elementInfo.getPreparedInfo().getConstraint() instanceof ASN1ValueRangeConstraintMetadata) {
                constraint = elementInfo.getPreparedInfo().getConstraint();
                hasConstraint = true;
                min = ((ASN1ValueRangeConstraintMetadata)constraint).getMin();
                max = ((ASN1ValueRangeConstraintMetadata)constraint).getMax();
            }
        } else if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1ValueRangeConstraint.class)) {
            hasConstraint = true;
            constraint = elementInfo.getAnnotatedClass().getAnnotation(ASN1ValueRangeConstraint.class);
            min = constraint.min();
            max = constraint.max();
        }
        if (objectClass.equals(Integer.class)) {
            result = new DecodedObject<Number>();
            BitArrayInputStream bitStream = (BitArrayInputStream)stream;
            int value = 0;
            value = hasConstraint ? (int)this.decodeConstraintNumber((int)min, (int)max, bitStream) : this.decodeUnconstraintNumber(bitStream);
            result.setValue(value);
            return result;
        }
        result = new DecodedObject();
        BitArrayInputStream bitStream = (BitArrayInputStream)stream;
        long value = 0L;
        value = hasConstraint ? this.decodeConstraintNumber(min, max, bitStream) : (long)this.decodeUnconstraintNumber(bitStream);
        result.setValue(value);
        return result;
    }

    @Override
    public DecodedObject decodeReal(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        BitArrayInputStream bitStream = (BitArrayInputStream)stream;
        int len = this.decodeLengthDeterminant(bitStream);
        int realPreamble = stream.read();
        this.skipAlignedBits(stream);
        Double result = 0.0;
        int szResult = len;
        if ((realPreamble & 0x40) == 1) {
            result = Double.POSITIVE_INFINITY;
        }
        if ((realPreamble & 0x41) == 1) {
            result = Double.NEGATIVE_INFINITY;
            ++szResult;
        } else if (len > 0) {
            int szOfExp = 1 + (realPreamble & 3);
            int sign = realPreamble & 0x40;
            int ff = (realPreamble & 0xC) >> 2;
            long exponent = this.decodeIntegerValueAsBytes(szOfExp, stream);
            long mantissaEncFrm = this.decodeIntegerValueAsBytes(szResult - szOfExp - 1, stream);
            long mantissa = mantissaEncFrm << ff;
            while ((mantissa & 0xFF00000000000L) == 0L) {
                exponent -= 8L;
                mantissa <<= 8;
            }
            while ((mantissa & 0x10000000000000L) == 0L) {
                --exponent;
                mantissa <<= 1;
            }
            long lValue = exponent + 1023L + 52L << 52;
            lValue |= (mantissa &= 0xFFFFFFFFFFFFFL);
            if (sign == 1) {
                lValue |= Long.MIN_VALUE;
            }
            result = Double.longBitsToDouble(lValue);
        }
        return new DecodedObject<Double>(result, szResult);
    }

    @Override
    public DecodedObject decodeOctetString(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        DecodedObject<byte[]> result = new DecodedObject<byte[]>();
        int sizeOfString = this.decodeLength(elementInfo, stream);
        this.skipAlignedBits(stream);
        if (sizeOfString > 0) {
            byte[] value = new byte[sizeOfString];
            stream.read(value);
            result.setValue(value);
        } else {
            result.setValue(new byte[0]);
        }
        return result;
    }

    @Override
    public DecodedObject decodeBitString(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        DecodedObject<BitString> result = new DecodedObject<BitString>();
        BitArrayInputStream bitStream = (BitArrayInputStream)stream;
        this.skipAlignedBits(stream);
        int sizeOfString = this.decodeLength(elementInfo, stream);
        this.skipAlignedBits(stream);
        int trailBits = 8 - sizeOfString % 8;
        if ((sizeOfString /= 8) > 0 || sizeOfString == 0 && trailBits > 0) {
            byte[] value = new byte[trailBits > 0 ? sizeOfString + 1 : sizeOfString];
            if (sizeOfString > 0) {
                stream.read(value, 0, sizeOfString);
            }
            if (trailBits > 0) {
                value[sizeOfString] = (byte)(bitStream.readBits(trailBits) << 8 - trailBits);
            }
            result.setValue(new BitString(value, trailBits));
        } else {
            result.setValue(new BitString(new byte[0]));
        }
        return result;
    }

    @Override
    public DecodedObject decodeString(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        DecodedObject<String> result = new DecodedObject<String>();
        int strLen = this.decodeLength(elementInfo, stream);
        this.skipAlignedBits(stream);
        if (strLen > 0) {
            byte[] value = new byte[strLen];
            stream.read(value);
            result.setValue(CoderUtils.bufferToASN1String(value, elementInfo));
        } else {
            result.setValue("");
        }
        return result;
    }

    @Override
    public DecodedObject decodeSequenceOf(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        LinkedList result = new LinkedList();
        int countOfElements = this.decodeLength(elementInfo, stream);
        if (countOfElements > 0) {
            Class<?> paramType = CoderUtils.getCollectionType(elementInfo);
            for (int i = 0; i < countOfElements; ++i) {
                DecodedObject item;
                ElementInfo info = new ElementInfo();
                info.setAnnotatedClass(paramType);
                info.setParentAnnotated(elementInfo.getAnnotatedClass());
                if (elementInfo.hasPreparedInfo()) {
                    ASN1SequenceOfMetadata seqOfMeta = (ASN1SequenceOfMetadata)elementInfo.getPreparedInfo().getTypeMetadata();
                    info.setPreparedInfo(seqOfMeta.getItemClassMetadata());
                }
                if ((item = this.decodeClassType(null, paramType, info, stream)) == null) continue;
                result.add(item.getValue());
            }
        }
        return new DecodedObject(result);
    }

    @Override
    public DecodedObject decodeObjectIdentifier(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        int len = this.decodeLength(elementInfo, stream);
        byte[] byteBuf = new byte[len];
        stream.read(byteBuf, 0, byteBuf.length);
        String dottedDecimal = BERObjectIdentifier.Decode(byteBuf);
        return new DecodedObject<ObjectIdentifier>(new ObjectIdentifier(dottedDecimal));
    }
}

