/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders.per;

import java.io.IOException;
import java.io.InputStream;
import org.bn.coders.DecodedObject;
import org.bn.coders.ElementInfo;
import org.bn.coders.per.PERAlignedDecoder;
import org.bn.coders.per.PERCoderUtils;
import org.bn.utils.BitArrayInputStream;

public class PERUnalignedDecoder
extends PERAlignedDecoder {
    @Override
    protected void skipAlignedBits(InputStream stream) {
    }

    @Override
    protected long decodeConstraintNumber(long min, long max, BitArrayInputStream stream) throws Exception {
        int result = 0;
        long valueRange = max - min;
        int maxBitLen = PERCoderUtils.getMaxBitLength(valueRange);
        if (valueRange == 0L) {
            return max;
        }
        int currentBit = maxBitLen;
        while (currentBit > 7) {
            result |= stream.read() << (currentBit -= 8);
        }
        if (currentBit > 0) {
            result |= stream.readBits(currentBit);
        }
        result = (int)((long)result + min);
        return result;
    }

    @Override
    public DecodedObject decodeString(DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws IOException, Exception {
        if (!PERCoderUtils.is7BitEncodedString(elementInfo)) {
            return super.decodeString(decodedTag, objectClass, elementInfo, stream);
        }
        DecodedObject<String> result = new DecodedObject<String>();
        int strLen = this.decodeLength(elementInfo, stream);
        if (strLen <= 0) {
            result.setValue("");
            return result;
        }
        BitArrayInputStream bitStream = (BitArrayInputStream)stream;
        byte[] buffer = new byte[strLen];
        for (int i = 0; i < strLen; ++i) {
            buffer[i] = (byte)bitStream.readBits(7);
        }
        result.setValue(new String(buffer));
        return result;
    }
}

