/*
 * Decompiled with CFR 0.152.
 */
package org.codejuicer.java2csharp.sharpen.customization;

import java.io.IOException;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class CompilationUnitExtended {
    private char windowsFolderSeparator = (char)92;
    private char linuxFolderSeparator = (char)47;
    private String fileName;
    private String basePath;
    private CompilationUnit compilationUnit;

    public CompilationUnitExtended(String fileName, String basePath, CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
        this.basePath = basePath;
        this.fileName = fileName;
    }

    public String getRelativePath() throws IOException {
        String ret = "";
        if (this.fileName.contains(this.basePath)) {
            int lastSlashIndex = -1;
            lastSlashIndex = this.fileName.lastIndexOf(this.windowsFolderSeparator);
            if (lastSlashIndex == -1) {
                lastSlashIndex = this.fileName.lastIndexOf(this.linuxFolderSeparator);
            }
            if (this.basePath.length() + 1 < lastSlashIndex) {
                ret = this.fileName.substring(this.basePath.length() + 1, lastSlashIndex);
            }
            return ret;
        }
        throw new IOException("file is not in base path or some subfolder");
    }

    public String retrieveCSharpFileNameFromJavaFileName(String filename) {
        int dotIndex = filename.lastIndexOf(".java");
        int slashIndex = -1;
        slashIndex = this.fileName.lastIndexOf(this.windowsFolderSeparator);
        if (slashIndex == -1) {
            slashIndex = this.fileName.lastIndexOf(this.linuxFolderSeparator);
        }
        return filename.substring(slashIndex + 1, dotIndex) + ".cs";
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public void setCompilationUnit(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

