/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;

public class IndentedWriter {
    private final int _maxColumns;
    String _lineSeparator = System.getProperty("line.separator");
    String _indentString = "\t";
    int _indentLevel = 0;
    private int _column;
    private Writer _delegate;
    private String _prefix;

    public IndentedWriter(Writer writer, int maxColumns) {
        this._delegate = writer;
        this._maxColumns = maxColumns;
    }

    public String getIndentString() {
        return this._indentString;
    }

    public void setIndentString(String indentString) {
        this._indentString = indentString;
    }

    public void indent() {
        ++this._indentLevel;
    }

    public void outdent() {
        --this._indentLevel;
    }

    public void writeIndented(String s) {
        this.writeIndentation();
        this.write(s);
    }

    public void writeIndentedLine(String s) {
        this.writeIndentation();
        this.writeLine(s);
    }

    public void write(String s) {
        if (this._column > this._maxColumns) {
            this.writeLine();
            this.writeIndented(this._indentString);
        }
        this.writeBlock(s);
    }

    public void writeBlock(String s) {
        this.uncheckedWrite(s);
        this._column += s.length();
    }

    public void writeLine() {
        this.writeLine("");
    }

    public void writeLine(String s) {
        try {
            this._delegate.write(s);
            this._delegate.write(this._lineSeparator);
            this._column = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void uncheckedWrite(String s) {
        try {
            this._delegate.write(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeIndentation() {
        for (int i = 0; i < this._indentLevel; ++i) {
            this.uncheckedWrite(this._indentString);
        }
        if (null != this._prefix) {
            this.uncheckedWrite(this._prefix);
        }
    }

    public Writer delegate() {
        return this._delegate;
    }

    public void writeLines(String lines) {
        BufferedReader lineReader = new BufferedReader(new StringReader(lines));
        try {
            String line;
            while (null != (line = lineReader.readLine())) {
                if (line.trim().length() > 0) {
                    this.writeIndentedLine(line);
                    continue;
                }
                this.writeLine();
            }
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public void linePrefix(String prefix) {
        this._prefix = prefix;
    }
}

