/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.annotation.server;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cometd.annotation.AnnotationProcessor;
import org.cometd.annotation.Listener;
import org.cometd.annotation.Service;
import org.cometd.annotation.Session;
import org.cometd.annotation.Subscription;
import org.cometd.annotation.server.Configure;
import org.cometd.annotation.server.RemoteCall;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.MarkedReference;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAnnotationProcessor
extends AnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerAnnotationProcessor.class);
    private final ConcurrentMap<Object, LocalSession> sessions = new ConcurrentHashMap<Object, LocalSession>();
    private final ConcurrentMap<Object, List<ListenerCallback>> listeners = new ConcurrentHashMap<Object, List<ListenerCallback>>();
    private final ConcurrentMap<Object, List<SubscriptionCallback>> subscribers = new ConcurrentHashMap<Object, List<SubscriptionCallback>>();
    private final ConcurrentMap<Object, List<RemoteCallCallback>> remoteCalls = new ConcurrentHashMap<Object, List<RemoteCallCallback>>();
    private final BayeuxServer bayeuxServer;
    private final List<Object> injectables;

    public ServerAnnotationProcessor(BayeuxServer bayeuxServer) {
        this(bayeuxServer, new Object[0]);
    }

    public ServerAnnotationProcessor(BayeuxServer bayeuxServer, Object ... injectables) {
        this.bayeuxServer = bayeuxServer;
        this.injectables = List.of(injectables);
    }

    public boolean process(Object service, Object ... injectables) {
        boolean result = this.processDependencies(service, injectables);
        result |= this.processConfigurations(service);
        result |= this.processCallbacks(service);
        return result |= this.processPostConstruct(service);
    }

    public boolean processConfigurations(Object service) {
        if (service == null) {
            return false;
        }
        Class<?> klass = service.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        List methods = this.findAnnotatedMethods(service, Configure.class);
        if (methods.isEmpty()) {
            return false;
        }
        for (Method method : methods) {
            String[] channels;
            Configure configure = method.getAnnotation(Configure.class);
            for (String channelName : channels = configure.value()) {
                ConfigurableServerChannel.Initializer init = channel -> {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Configure channel {} with method {} on service {}", new Object[]{channel, method, service});
                    }
                    this.invokePrivate(service, method, new Object[]{channel});
                };
                MarkedReference initializedChannel = this.bayeuxServer.createChannelIfAbsent(channelName, new ConfigurableServerChannel.Initializer[]{init});
                if (initializedChannel.isMarked()) continue;
                if (configure.configureIfExists()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Configure again channel {} with method {} on service {}", new Object[]{channelName, method, service});
                    }
                    init.configureChannel((ConfigurableServerChannel)initializedChannel.getReference());
                    continue;
                }
                if (configure.errorIfExists()) {
                    throw new IllegalStateException("Channel already configured: " + channelName);
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Channel {} already initialized. Not called method {} on service {}", new Object[]{channelName, method, service});
            }
        }
        return true;
    }

    public boolean processDependencies(Object service, Object ... extraInjectables) {
        if (service == null) {
            return false;
        }
        Class<?> klass = service.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        ArrayList<Object> allInjectables = new ArrayList<Object>();
        allInjectables.add(this.bayeuxServer);
        allInjectables.addAll(this.injectables);
        allInjectables.addAll(List.of(extraInjectables));
        boolean result = this.processInjectables(service, allInjectables);
        LocalSession session = this.findOrCreateLocalSession(service, serviceAnnotation.value());
        return result |= this.processSession(service, session);
    }

    public boolean processPostConstruct(Object service) {
        return super.processPostConstruct(service);
    }

    public boolean processCallbacks(Object service) {
        if (service == null) {
            return false;
        }
        Class<?> klass = service.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        if (!Modifier.isPublic(klass.getModifiers())) {
            throw new IllegalArgumentException("Service class " + klass.getName() + " must be public");
        }
        LocalSession session = this.findOrCreateLocalSession(service, serviceAnnotation.value());
        boolean result = this.processListener(service, session);
        result |= this.processSubscription(service, session);
        return result |= this.processRemoteCall(service, session);
    }

    public boolean deprocess(Object service) {
        boolean result = this.deprocessCallbacks(service);
        return result |= this.processPreDestroy(service);
    }

    public boolean deprocessCallbacks(Object service) {
        if (service == null) {
            return false;
        }
        Class<?> klass = service.getClass();
        Service serviceAnnotation = klass.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            return false;
        }
        boolean result = this.deprocessListener(service);
        result |= this.deprocessSubscription(service);
        this.destroyLocalSession(service);
        return result |= this.deprocessRemoteCall(service);
    }

    private void destroyLocalSession(Object service) {
        LocalSession session = (LocalSession)this.sessions.remove(service);
        if (session != null) {
            session.disconnect();
        }
    }

    public boolean processPreDestroy(Object service) {
        return super.processPreDestroy(service);
    }

    private LocalSession findOrCreateLocalSession(Object service, String name) {
        LocalSession session = (LocalSession)this.sessions.get(service);
        if (session == null) {
            session = this.bayeuxServer.newLocalSession(name);
            LocalSession existing = this.sessions.putIfAbsent(service, session);
            if (existing != null) {
                session = existing;
            } else {
                session.handshake();
            }
        }
        return session;
    }

    private boolean processSession(Object service, LocalSession localSession) {
        ServerSession serverSession = localSession.getServerSession();
        boolean result = false;
        for (Class<?> c = service.getClass(); c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (field.getAnnotation(Session.class) == null) continue;
                LocalSession value = null;
                if (field.getType().isAssignableFrom(localSession.getClass())) {
                    value = localSession;
                } else if (field.getType().isAssignableFrom(serverSession.getClass())) {
                    value = serverSession;
                }
                if (value == null) continue;
                this.setField(service, field, value);
                result = true;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Injected {} to field {} on service {}", new Object[]{value, field, service});
            }
        }
        List methods = this.findAnnotatedMethods(service, Session.class);
        for (Method method : methods) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) continue;
            LocalSession value = null;
            if (parameterTypes[0].isAssignableFrom(localSession.getClass())) {
                value = localSession;
            } else if (parameterTypes[0].isAssignableFrom(serverSession.getClass())) {
                value = serverSession;
            }
            if (value == null) continue;
            this.invokePrivate(service, method, new Object[]{value});
            result = true;
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Injected {} to method {} on service {}", new Object[]{value, method, service});
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private boolean processListener(Object service, LocalSession localSession) {
        Method[] methods;
        AnnotationProcessor.checkMethodsPublic((Object)service, Listener.class);
        boolean result = false;
        for (Method method : methods = service.getClass().getMethods()) {
            String[] channels;
            Listener listener;
            if (method.getDeclaringClass() == Object.class || (listener = method.getAnnotation(Listener.class)) == null) continue;
            List paramNames = this.processParameters(method);
            AnnotationProcessor.checkSignaturesMatch((Method)method, (Class[])ListenerCallback.signature, (List)paramNames);
            for (String string : channels = listener.value()) {
                List existing;
                void var15_15;
                ChannelId channelId = new ChannelId(string);
                if (channelId.isTemplate()) {
                    List parameters = channelId.getParameters();
                    if (parameters.size() != paramNames.size()) {
                        throw new IllegalArgumentException("Wrong number of template parameters in annotation @" + Listener.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...)");
                    }
                    if (!parameters.equals(paramNames)) {
                        throw new IllegalArgumentException("Wrong parameter names in annotation @" + Listener.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...)");
                    }
                    String string2 = channelId.getRegularPart() + "/" + (parameters.size() < 2 ? "*" : "**");
                }
                MarkedReference initializedChannel = this.bayeuxServer.createChannelIfAbsent((String)var15_15, new ConfigurableServerChannel.Initializer[0]);
                ListenerCallback listenerCallback = new ListenerCallback(localSession, service, method, paramNames, channelId, (String)var15_15, listener.receiveOwnPublishes());
                ((ServerChannel)initializedChannel.getReference()).addListener((ConfigurableServerChannel.ServerChannelListener)listenerCallback);
                List<ListenerCallback> callbacks = (CopyOnWriteArrayList<ListenerCallback>)this.listeners.get(service);
                if (callbacks == null && (existing = (List)this.listeners.putIfAbsent(service, callbacks = new CopyOnWriteArrayList<ListenerCallback>())) != null) {
                    callbacks = existing;
                }
                callbacks.add(listenerCallback);
                result = true;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Registered listener for channel {} to method {} on service {}", new Object[]{var15_15, method, service});
            }
        }
        return result;
    }

    private boolean deprocessListener(Object service) {
        boolean result = false;
        List callbacks = (List)this.listeners.remove(service);
        if (callbacks != null) {
            for (ListenerCallback callback : callbacks) {
                ServerChannel channel = this.bayeuxServer.getChannel(callback.subscription);
                if (channel == null) continue;
                channel.removeListener((ConfigurableServerChannel.ServerChannelListener)callback);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private boolean processSubscription(Object service, LocalSession localSession) {
        Method[] methods;
        AnnotationProcessor.checkMethodsPublic((Object)service, Subscription.class);
        boolean result = false;
        for (Method method : methods = service.getClass().getMethods()) {
            String[] channels;
            Subscription subscription;
            if (method.getDeclaringClass() == Object.class || (subscription = method.getAnnotation(Subscription.class)) == null) continue;
            List paramNames = this.processParameters(method);
            AnnotationProcessor.checkSignaturesMatch((Method)method, (Class[])SubscriptionCallback.signature, (List)paramNames);
            for (String string : channels = subscription.value()) {
                List existing;
                void var15_15;
                if (ChannelId.isMeta((String)string)) {
                    throw new IllegalArgumentException("Annotation @" + Subscription.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...) must specify a non meta channel");
                }
                ChannelId channelId = new ChannelId(string);
                if (channelId.isTemplate()) {
                    List parameters = channelId.getParameters();
                    if (parameters.size() != paramNames.size()) {
                        throw new IllegalArgumentException("Wrong number of template parameters in annotation @" + Subscription.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...)");
                    }
                    if (!parameters.equals(paramNames)) {
                        throw new IllegalArgumentException("Wrong parameter names in annotation @" + Subscription.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...)");
                    }
                    String string2 = channelId.getRegularPart() + "/" + (parameters.size() < 2 ? "*" : "**");
                }
                SubscriptionCallback subscriptionCallback = new SubscriptionCallback(localSession, service, method, paramNames, channelId, (String)var15_15);
                localSession.getChannel((String)var15_15).subscribe((ClientSessionChannel.MessageListener)subscriptionCallback);
                List<SubscriptionCallback> callbacks = (CopyOnWriteArrayList<SubscriptionCallback>)this.subscribers.get(service);
                if (callbacks == null && (existing = (List)this.subscribers.putIfAbsent(service, callbacks = new CopyOnWriteArrayList<SubscriptionCallback>())) != null) {
                    callbacks = existing;
                }
                callbacks.add(subscriptionCallback);
                result = true;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Registered subscriber for channel {} to method {} on service {}", new Object[]{var15_15, method, service});
            }
        }
        return result;
    }

    private boolean deprocessSubscription(Object service) {
        boolean result = false;
        List callbacks = (List)this.subscribers.remove(service);
        if (callbacks != null) {
            for (SubscriptionCallback callback : callbacks) {
                callback.localSession.getChannel(callback.subscription).unsubscribe((ClientSessionChannel.MessageListener)callback);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private boolean processRemoteCall(Object service, LocalSession localSession) {
        Method[] methods;
        AnnotationProcessor.checkMethodsPublic((Object)service, RemoteCall.class);
        boolean result = false;
        for (Method method : methods = service.getClass().getMethods()) {
            String[] targets;
            RemoteCall remoteCall = method.getAnnotation(RemoteCall.class);
            if (remoteCall == null) continue;
            List paramNames = this.processParameters(method);
            AnnotationProcessor.checkSignaturesMatch((Method)method, (Class[])RemoteCallCallback.signature, (List)paramNames);
            for (String string : targets = remoteCall.value()) {
                List existing;
                void var15_15;
                String channel;
                ChannelId channelId;
                if (!string.startsWith("/")) {
                    String string2 = "/" + string;
                }
                if ((channelId = new ChannelId(channel = "/service" + (String)var15_15)).isWild()) {
                    throw new IllegalArgumentException("Annotation @" + RemoteCall.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...) cannot specify wild channels.");
                }
                if (channelId.isTemplate()) {
                    List parameters = channelId.getParameters();
                    if (parameters.size() != paramNames.size()) {
                        throw new IllegalArgumentException("Wrong number of template parameters in annotation @" + RemoteCall.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...)");
                    }
                    if (!parameters.equals(paramNames)) {
                        throw new IllegalArgumentException("Wrong parameter names in annotation @" + RemoteCall.class.getSimpleName() + " on method " + method.getDeclaringClass().getName() + "." + method.getName() + "(...)");
                    }
                    channel = channelId.getRegularPart() + "/" + (parameters.size() < 2 ? "*" : "**");
                }
                MarkedReference initializedChannel = this.bayeuxServer.createChannelIfAbsent(channel, new ConfigurableServerChannel.Initializer[0]);
                RemoteCallCallback remoteCallCallback = new RemoteCallCallback(this.bayeuxServer, localSession, service, method, paramNames, channelId, channel);
                ((ServerChannel)initializedChannel.getReference()).addListener((ConfigurableServerChannel.ServerChannelListener)remoteCallCallback);
                List<RemoteCallCallback> callbacks = (CopyOnWriteArrayList<RemoteCallCallback>)this.remoteCalls.get(service);
                if (callbacks == null && (existing = (List)this.remoteCalls.putIfAbsent(service, callbacks = new CopyOnWriteArrayList<RemoteCallCallback>())) != null) {
                    callbacks = existing;
                }
                callbacks.add(remoteCallCallback);
                result = true;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Registered remote call for channel {} to method {} on service {}", new Object[]{var15_15, method, service});
            }
        }
        return result;
    }

    private boolean deprocessRemoteCall(Object service) {
        boolean result = false;
        List callbacks = (List)this.remoteCalls.remove(service);
        if (callbacks != null) {
            for (RemoteCallCallback callback : callbacks) {
                ServerChannel channel = this.bayeuxServer.getChannel(callback.subscription);
                if (channel == null) continue;
                channel.removeListener((ConfigurableServerChannel.ServerChannelListener)callback);
                result = true;
            }
        }
        return result;
    }

    private static class ListenerCallback
    implements ServerChannel.MessageListener {
        private static final Class<?>[] signature = new Class[]{ServerSession.class, ServerMessage.Mutable.class};
        private final LocalSession localSession;
        private final Object target;
        private final Method method;
        private final ChannelId channelId;
        private final String subscription;
        private final boolean receiveOwnPublishes;
        private final List<String> paramNames;

        private ListenerCallback(LocalSession localSession, Object target, Method method, List<String> paramNames, ChannelId channelId, String subscription, boolean receiveOwnPublishes) {
            this.localSession = localSession;
            this.target = target;
            this.method = method;
            this.paramNames = paramNames;
            this.channelId = channelId;
            this.subscription = subscription;
            this.receiveOwnPublishes = receiveOwnPublishes;
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (from == this.localSession.getServerSession() && !this.receiveOwnPublishes) {
                return true;
            }
            Map matches = this.channelId.bind(channel.getChannelId());
            if (!this.paramNames.isEmpty() && !matches.keySet().containsAll(this.paramNames)) {
                return true;
            }
            Object[] args = new Object[2 + this.paramNames.size()];
            args[0] = from;
            args[1] = message;
            for (int i = 0; i < this.paramNames.size(); ++i) {
                args[2 + i] = matches.get(this.paramNames.get(i));
            }
            return !Boolean.FALSE.equals(ServerAnnotationProcessor.callPublic((Object)this.target, (Method)this.method, (Object[])args));
        }
    }

    private static class SubscriptionCallback
    implements ClientSessionChannel.MessageListener {
        private static final Class<?>[] signature = new Class[]{Message.class};
        private final LocalSession localSession;
        private final Object target;
        private final Method method;
        private final List<String> paramNames;
        private final ChannelId channelId;
        private final String subscription;

        public SubscriptionCallback(LocalSession localSession, Object target, Method method, List<String> paramNames, ChannelId channelId, String subscription) {
            this.localSession = localSession;
            this.target = target;
            this.method = method;
            this.paramNames = paramNames;
            this.channelId = channelId;
            this.subscription = subscription;
        }

        public void onMessage(ClientSessionChannel channel, Message message) {
            Map matches = this.channelId.bind(message.getChannelId());
            if (!this.paramNames.isEmpty() && !matches.keySet().containsAll(this.paramNames)) {
                return;
            }
            Object[] args = new Object[1 + this.paramNames.size()];
            args[0] = message;
            for (int i = 0; i < this.paramNames.size(); ++i) {
                args[1 + i] = matches.get(this.paramNames.get(i));
            }
            ServerAnnotationProcessor.callPublic((Object)this.target, (Method)this.method, (Object[])args);
        }
    }

    private static class RemoteCallCallback
    implements ServerChannel.MessageListener {
        private static final Class<?>[] signature = new Class[]{RemoteCall.Caller.class, null};
        private final BayeuxServer bayeuxServer;
        private final LocalSession localSession;
        private final Object target;
        private final Method method;
        private final List<String> paramNames;
        private final ChannelId channelId;
        private final String subscription;

        private RemoteCallCallback(BayeuxServer bayeuxServer, LocalSession localSession, Object target, Method method, List<String> paramNames, ChannelId channelId, String subscription) {
            this.bayeuxServer = bayeuxServer;
            this.localSession = localSession;
            this.target = target;
            this.method = method;
            this.paramNames = paramNames;
            this.channelId = channelId;
            this.subscription = subscription;
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (from == this.localSession.getServerSession()) {
                return true;
            }
            Map matches = this.channelId.bind(channel.getChannelId());
            if (!this.paramNames.isEmpty() && !matches.keySet().containsAll(this.paramNames)) {
                return true;
            }
            Object[] args = new Object[2 + this.paramNames.size()];
            CallerImpl caller = new CallerImpl(this.bayeuxServer, this.localSession, from, message.getId(), message.getChannel());
            args[0] = caller;
            args[1] = message.getData();
            for (int i = 0; i < this.paramNames.size(); ++i) {
                args[2 + i] = matches.get(this.paramNames.get(i));
            }
            try {
                return !Boolean.FALSE.equals(ServerAnnotationProcessor.invokePublic((Object)this.target, (Method)this.method, (Object[])args));
            }
            catch (Throwable x) {
                HashMap<String, String> failure = new HashMap<String, String>();
                failure.put("class", x.getClass().getName());
                failure.put("message", x.getMessage());
                caller.failure(failure);
                Class<?> klass = this.target.getClass();
                Logger logger = LoggerFactory.getLogger(klass);
                logger.info("Exception while invoking {}#{}()", new Object[]{klass, this.method.getName(), x});
                return true;
            }
        }
    }

    private static class CallerImpl
    implements RemoteCall.Caller {
        private final AtomicBoolean complete = new AtomicBoolean();
        private final BayeuxServer bayeux;
        private final LocalSession sender;
        private final ServerSession session;
        private final String messageId;
        private final String channel;

        private CallerImpl(BayeuxServer bayeux, LocalSession sender, ServerSession session, String messageId, String channel) {
            this.bayeux = bayeux;
            this.sender = sender;
            this.session = session;
            this.messageId = messageId;
            this.channel = channel;
        }

        @Override
        public ServerSession getServerSession() {
            return this.session;
        }

        @Override
        public boolean result(Object result) {
            return this.deliver(result, true);
        }

        @Override
        public boolean failure(Object failure) {
            return this.deliver(failure, false);
        }

        private boolean deliver(Object data, boolean successful) {
            boolean completed = this.complete.compareAndSet(false, true);
            if (completed) {
                ServerMessage.Mutable message = this.bayeux.newMessage();
                message.setId(this.messageId);
                message.setSuccessful(successful);
                message.setChannel(this.channel);
                message.setData(data);
                this.session.deliver((org.cometd.bayeux.Session)this.sender, message, Promise.noop());
            }
            return completed;
        }
    }
}

