/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.ext;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;

public class TimestampClientExtension
implements ClientSession.Extension {
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US).withZone(ZoneId.of("GMT"));

    @Override
    public boolean send(ClientSession session, Message.Mutable message) {
        this.addTimestamp(message);
        return true;
    }

    @Override
    public boolean sendMeta(ClientSession session, Message.Mutable message) {
        this.addTimestamp(message);
        return true;
    }

    private void addTimestamp(Message.Mutable message) {
        message.put("timestamp", this.formatter.format(Instant.now()));
    }
}

