/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.websocket.jetty;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.UnresolvedAddressException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.client.websocket.common.AbstractWebSocketTransport;
import org.cometd.common.TransportException;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketTransport
extends AbstractWebSocketTransport
implements UpgradeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyWebSocketTransport.class);
    private final WebSocketClient _webSocketClient;
    private boolean _webSocketSupported;
    private boolean _webSocketConnected;

    public JettyWebSocketTransport(Map<String, Object> options, ScheduledExecutorService scheduler, WebSocketClient webSocketClient) {
        this(null, options, scheduler, webSocketClient);
    }

    public JettyWebSocketTransport(String url, Map<String, Object> options, ScheduledExecutorService scheduler, WebSocketClient webSocketClient) {
        super(url, options, scheduler);
        this._webSocketClient = webSocketClient;
        this._webSocketSupported = true;
    }

    @Override
    public boolean accept(String version) {
        return this._webSocketSupported;
    }

    @Override
    public void init() {
        super.init();
        this._webSocketClient.setConnectTimeout(this.getConnectTimeout());
        this._webSocketClient.setCookieStore(this.getCookieStore());
        this._webSocketClient.getPolicy().setIdleTimeout(this.getIdleTimeout());
        int maxMessageSize = this.getOption("maxMessageSize", this._webSocketClient.getPolicy().getMaxTextMessageSize());
        this._webSocketClient.getPolicy().setMaxTextMessageSize(maxMessageSize);
        this._webSocketSupported = true;
        this._webSocketConnected = false;
    }

    @Override
    protected AbstractWebSocketTransport.Delegate connect(String uri, TransportListener listener, List<Message.Mutable> messages) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Opening websocket session to {}", (Object)uri);
            }
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            String protocol = this.getProtocol();
            if (protocol != null) {
                request.setSubProtocols(protocol);
            }
            AbstractWebSocketTransport.Delegate delegate = this.connect(this._webSocketClient, request, uri);
            this._webSocketConnected = true;
            return delegate;
        }
        catch (ConnectException | SocketTimeoutException | UnresolvedAddressException x) {
            listener.onFailure(x, messages);
        }
        catch (UpgradeException x) {
            this._webSocketSupported = false;
            HashMap<String, Object> failure = new HashMap<String, Object>(2);
            failure.put("websocketCode", 1002);
            failure.put("httpCode", x.getResponseStatusCode());
            listener.onFailure(new TransportException(x, failure), messages);
        }
        catch (Throwable x) {
            this._webSocketSupported = this.isStickyReconnect() && this._webSocketConnected;
            listener.onFailure(x, messages);
        }
        return null;
    }

    protected AbstractWebSocketTransport.Delegate connect(WebSocketClient client, ClientUpgradeRequest request, String uri) throws IOException, InterruptedException {
        try {
            AbstractWebSocketTransport.Delegate delegate = this.newDelegate();
            long timeout = this.getConnectTimeout() + 1000L;
            client.connect(delegate, new URI(uri), request, this).get(timeout, TimeUnit.MILLISECONDS);
            return delegate;
        }
        catch (TimeoutException e) {
            throw new ConnectException("Connect timeout");
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
        catch (URISyntaxException x) {
            throw new IOException(x);
        }
    }

    protected AbstractWebSocketTransport.Delegate newDelegate() {
        return new JettyWebSocketDelegate();
    }

    @Override
    public void onHandshakeRequest(UpgradeRequest request) {
    }

    @Override
    public void onHandshakeResponse(UpgradeResponse response) {
        this.storeCookies(URI.create(this.getURL()), response.getHeaders());
    }

    protected class JettyWebSocketDelegate
    extends AbstractWebSocketTransport.Delegate
    implements WebSocketListener {
        private Session _session;

        protected JettyWebSocketDelegate() {
        }

        @Override
        public void onWebSocketConnect(Session session) {
            JettyWebSocketTransport.this.locked(() -> {
                this._session = session;
                return this._session;
            });
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Opened websocket session {}", (Object)session);
            }
        }

        @Override
        public void onWebSocketClose(int closeCode, String reason) {
            this.onClose(closeCode, reason);
        }

        @Override
        public void onWebSocketText(String data) {
            this.onData(data);
        }

        @Override
        public void onWebSocketBinary(byte[] payload, int offset, int len) {
        }

        @Override
        public void onWebSocketError(Throwable failure) {
            this.failMessages(failure);
        }

        @Override
        public void send(String content) {
            Session session = (Session)JettyWebSocketTransport.this.locked(() -> this._session);
            try {
                if (session == null) {
                    throw new IOException("Unconnected");
                }
                long timeout = JettyWebSocketTransport.this.getIdleTimeout() + 1000L;
                session.getRemote().sendStringByFuture(content).get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException x) {
                this.fail(x, "Timeout");
            }
            catch (ExecutionException x) {
                this.fail(x.getCause(), "Exception");
            }
            catch (Throwable x) {
                this.fail(x, "Failure");
            }
        }

        @Override
        protected void shutdown(String reason) {
            Session session = (Session)JettyWebSocketTransport.this.locked(() -> {
                Session result = this._session;
                this.close();
                return result;
            });
            if (session != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Closing websocket session {}", (Object)session);
                }
                session.close(1000, reason);
            }
        }

        @Override
        protected boolean isOpen() {
            return (Boolean)JettyWebSocketTransport.this.locked(() -> super.isOpen() && this._session != null);
        }

        @Override
        protected void close() {
            JettyWebSocketTransport.this.locked(() -> {
                this._session = null;
                return null;
            });
        }
    }

    public static class Factory
    extends ContainerLifeCycle
    implements ClientTransport.Factory {
        private final WebSocketClient wsClient;

        public Factory(WebSocketClient wsClient) {
            this.wsClient = wsClient;
            this.addBean(wsClient);
        }

        @Override
        public ClientTransport newClientTransport(String url, Map<String, Object> options) {
            ScheduledExecutorService scheduler = (ScheduledExecutorService)options.get("scheduler");
            return new JettyWebSocketTransport(url, options, scheduler, this.wsClient);
        }
    }
}

