/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.net.URI;
import java.util.function.Supplier;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;

public class HttpSenderOverHTTP2
extends HttpSender {
    public HttpSenderOverHTTP2(HttpChannelOverHTTP2 channel) {
        super(channel);
    }

    @Override
    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    @Override
    protected void sendHeaders(HttpExchange exchange, HttpContent content, Callback callback) {
        HeadersFrame headersFrame;
        HttpRequest request = exchange.getRequest();
        String path = this.relativize(request.getPath());
        HttpURI uri = HttpURI.createHttpURI(request.getScheme(), request.getHost(), request.getPort(), path, null, request.getQuery(), null);
        MetaData.Request metaData = new MetaData.Request(request.getMethod(), uri, HttpVersion.HTTP_2, request.getHeaders());
        metaData.setTrailerSupplier(request.getTrailers());
        DataFrame dataFrame = null;
        HeadersFrame trailersFrame = null;
        if (content.hasContent()) {
            headersFrame = new HeadersFrame(metaData, null, false);
            if (!this.expects100Continue(request)) {
                boolean advanced = content.advance();
                boolean lastContent = content.isLast();
                if (advanced) {
                    if (lastContent) {
                        HttpFields trailers = this.retrieveTrailers(request);
                        boolean hasTrailers = trailers != null;
                        dataFrame = new DataFrame(content.getByteBuffer(), !hasTrailers);
                        if (hasTrailers) {
                            trailersFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_2, trailers), null, true);
                        }
                    } else {
                        dataFrame = new DataFrame(content.getByteBuffer(), false);
                    }
                } else if (lastContent) {
                    HttpFields trailers = this.retrieveTrailers(request);
                    if (trailers != null) {
                        trailersFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_2, trailers), null, true);
                    } else {
                        dataFrame = new DataFrame(BufferUtil.EMPTY_BUFFER, true);
                    }
                }
            }
        } else {
            HttpFields trailers = this.retrieveTrailers(request);
            boolean hasTrailers = trailers != null;
            headersFrame = new HeadersFrame(metaData, null, !hasTrailers);
            if (hasTrailers) {
                trailersFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_2, trailers), null, true);
            }
        }
        HttpChannelOverHTTP2 channel = this.getHttpChannel();
        IStream.FrameList frameList = new IStream.FrameList(headersFrame, dataFrame, trailersFrame);
        ((ISession)channel.getSession()).newStream(frameList, (Promise<Stream>)new HeadersPromise(request, callback), channel.getStreamListener());
    }

    private String relativize(String path) {
        try {
            String result = path;
            URI uri = URI.create(result);
            if (uri.isAbsolute()) {
                result = uri.getPath();
            }
            return result.isEmpty() ? "/" : result;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not relativize " + path, new Object[0]);
            }
            return path;
        }
    }

    private HttpFields retrieveTrailers(HttpRequest request) {
        Supplier<HttpFields> trailerSupplier = request.getTrailers();
        HttpFields trailers = trailerSupplier == null ? null : trailerSupplier.get();
        return trailers == null || trailers.size() == 0 ? null : trailers;
    }

    @Override
    protected void sendContent(HttpExchange exchange, HttpContent content, Callback callback) {
        if (content.isConsumed()) {
            callback.succeeded();
        } else {
            this.sendContent(this.getHttpChannel().getStream(), exchange.getRequest(), content, callback);
        }
    }

    private void sendContent(Stream stream, HttpRequest request, HttpContent content, Callback callback) {
        if (content.isLast()) {
            HttpFields trailers = this.retrieveTrailers(request);
            boolean hasTrailers = trailers != null;
            DataFrame dataFrame = new DataFrame(stream.getId(), content.getByteBuffer(), !hasTrailers);
            if (hasTrailers) {
                stream.data(dataFrame, Callback.from(() -> this.sendTrailers(stream, trailers, callback), callback::failed));
            } else {
                stream.data(dataFrame, callback);
            }
        } else {
            DataFrame dataFrame = new DataFrame(stream.getId(), content.getByteBuffer(), false);
            stream.data(dataFrame, callback);
        }
    }

    private void sendTrailers(Stream stream, HttpFields trailers, Callback callback) {
        MetaData metaData = new MetaData(HttpVersion.HTTP_2, trailers);
        HeadersFrame trailersFrame = new HeadersFrame(stream.getId(), metaData, null, true);
        stream.headers(trailersFrame, callback);
    }

    private class HeadersPromise
    implements Promise<Stream> {
        private final HttpRequest request;
        private final Callback callback;

        private HeadersPromise(HttpRequest request, Callback callback) {
            this.request = request;
            this.callback = callback;
        }

        @Override
        public void succeeded(Stream stream) {
            HttpChannelOverHTTP2 channel = HttpSenderOverHTTP2.this.getHttpChannel();
            channel.setStream(stream);
            ((IStream)stream).setAttachment(channel);
            long idleTimeout = this.request.getIdleTimeout();
            if (idleTimeout >= 0L) {
                stream.setIdleTimeout(idleTimeout);
            }
            this.callback.succeeded();
        }

        @Override
        public void failed(Throwable x) {
            this.callback.failed(x);
        }
    }
}

