/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.benchmark;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.benchmark.Atomics;

public class MonitoringThreadPoolExecutor
extends ThreadPoolExecutor {
    private final AtomicLong tasks = new AtomicLong();
    private final AtomicLong maxTaskLatency = new AtomicLong();
    private final AtomicLong totalTaskLatency = new AtomicLong();
    private final MonitoringLinkedBlockingQueue queue;
    private final AtomicLong maxQueueLatency = new AtomicLong();
    private final AtomicLong totalQueueLatency = new AtomicLong();
    private final AtomicInteger threads = new AtomicInteger();
    private final AtomicInteger maxThreads = new AtomicInteger();

    public MonitoringThreadPoolExecutor(int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(maximumPoolSize, keepAliveTime, unit, new ThreadPoolExecutor.AbortPolicy());
    }

    public MonitoringThreadPoolExecutor(int maximumPoolSize, long keepAliveTime, TimeUnit unit, RejectedExecutionHandler handler) {
        super(maximumPoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)new MonitoringLinkedBlockingQueue(), handler);
        this.queue = (MonitoringLinkedBlockingQueue)this.getQueue();
    }

    public void reset() {
        this.tasks.set(0L);
        this.maxTaskLatency.set(0L);
        this.totalTaskLatency.set(0L);
        this.queue.reset();
        this.maxQueueLatency.set(0L);
        this.totalQueueLatency.set(0L);
        this.threads.set(0);
        this.maxThreads.set(0);
    }

    public long getTasks() {
        return this.tasks.get();
    }

    public long getMaxTaskLatency() {
        return this.maxTaskLatency.get();
    }

    public long getAverageTaskLatency() {
        long count = this.tasks.get();
        return count == 0L ? -1L : this.totalTaskLatency.get() / count;
    }

    public long getMaxQueueLatency() {
        return this.maxQueueLatency.get();
    }

    public long getAverageQueueLatency() {
        long count = this.tasks.get();
        return count == 0L ? -1L : this.totalQueueLatency.get() / count;
    }

    public int getMaxQueueSize() {
        return this.queue.maxSize.get();
    }

    public int getMaxActiveThreads() {
        return this.maxThreads.get();
    }

    @Override
    public void execute(Runnable task) {
        long begin = System.nanoTime();
        super.execute(() -> {
            long latency = System.nanoTime() - begin;
            this.tasks.incrementAndGet();
            Atomics.updateMax(this.maxQueueLatency, latency);
            this.totalQueueLatency.addAndGet(latency);
            Atomics.updateMax(this.maxThreads, this.threads.incrementAndGet());
            long start = System.nanoTime();
            try {
                task.run();
            }
            finally {
                long taskLatency = System.nanoTime() - start;
                this.threads.decrementAndGet();
                Atomics.updateMax(this.maxTaskLatency, taskLatency);
                this.totalTaskLatency.addAndGet(taskLatency);
            }
        });
    }

    private static class MonitoringLinkedBlockingQueue
    extends LinkedBlockingQueue<Runnable> {
        private final AtomicInteger size = new AtomicInteger();
        private final AtomicInteger maxSize = new AtomicInteger();

        private MonitoringLinkedBlockingQueue() {
        }

        public void reset() {
            this.size.set(0);
            this.maxSize.set(0);
        }

        @Override
        public void clear() {
            this.reset();
            super.clear();
        }

        @Override
        public boolean offer(Runnable task) {
            boolean added = super.offer(task);
            if (added) {
                this.increment();
            }
            return added;
        }

        private void increment() {
            Atomics.updateMax(this.maxSize, this.size.incrementAndGet());
        }

        @Override
        public Runnable poll() {
            Runnable task = (Runnable)super.poll();
            if (task != null) {
                this.decrement();
            }
            return task;
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            Runnable task = (Runnable)super.poll(timeout, unit);
            if (task != null) {
                this.decrement();
            }
            return task;
        }

        @Override
        public Runnable take() throws InterruptedException {
            Runnable task = (Runnable)super.take();
            this.decrement();
            return task;
        }

        private void decrement() {
            this.size.decrementAndGet();
        }
    }
}

