/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractService.class);
    private final Map<String, Invoker> invokers = new ConcurrentHashMap<String, Invoker>();
    private final String _name;
    private final BayeuxServerImpl _bayeux;
    private final LocalSession _session;
    private ThreadPool _threadPool;
    private boolean _seeOwn = false;

    public AbstractService(BayeuxServer bayeux, String name) {
        this(bayeux, name, 0);
    }

    public AbstractService(BayeuxServer bayeux, String name, int maxThreads) {
        this._name = name;
        this._bayeux = (BayeuxServerImpl)bayeux;
        this._session = this._bayeux.newLocalSession(name);
        this._session.handshake();
        if (maxThreads > 0) {
            this.setThreadPool(new QueuedThreadPool(maxThreads));
        }
        if (!Modifier.isPublic(this.getClass().getModifiers())) {
            throw new IllegalArgumentException("Service class '" + this.getClass().getName() + "' must be public");
        }
    }

    public BayeuxServer getBayeux() {
        return this._bayeux;
    }

    public String getName() {
        return this._name;
    }

    public LocalSession getLocalSession() {
        return this._session;
    }

    public ServerSession getServerSession() {
        return this._session.getServerSession();
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool pool) {
        try {
            if (pool instanceof LifeCycle && !((LifeCycle)((Object)pool)).isStarted()) {
                ((LifeCycle)((Object)pool)).start();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this._threadPool = pool;
    }

    public boolean isSeeOwnPublishes() {
        return this._seeOwn;
    }

    public void setSeeOwnPublishes(boolean seeOwnPublishes) {
        this._seeOwn = seeOwnPublishes;
    }

    protected void addService(String channelName, String methodName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Mapping {}#{} to {}", this._name, methodName, channelName);
        }
        Method candidate = null;
        for (Class<?> c = this.getClass(); c != null && c != AbstractService.class; c = c.getSuperclass()) {
            Method[] methods = c.getDeclaredMethods();
            int i = methods.length;
            while (i-- > 0) {
                Method method = methods[i];
                if (!methodName.equals(method.getName()) || !Modifier.isPublic(method.getModifiers())) continue;
                if (candidate != null) {
                    throw new IllegalArgumentException("Multiple service methods called '" + methodName + "'");
                }
                candidate = method;
            }
        }
        if (candidate == null) {
            throw new NoSuchMethodError("Cannot find public service method '" + methodName + "'");
        }
        int params = candidate.getParameterTypes().length;
        if (params != 2) {
            throw new IllegalArgumentException("Service method '" + methodName + "' must have 2 parameters");
        }
        if (!ServerSession.class.isAssignableFrom(candidate.getParameterTypes()[0])) {
            throw new IllegalArgumentException("Service method '" + methodName + "' does not have " + ServerSession.class.getName() + " as first parameter");
        }
        if (!ServerMessage.class.isAssignableFrom(candidate.getParameterTypes()[1])) {
            throw new IllegalArgumentException("Service method '" + methodName + "' does not have " + ServerMessage.class.getName() + " as second parameter");
        }
        ServerChannel channel = this._bayeux.createChannelIfAbsent(channelName, new ConfigurableServerChannel.Initializer[0]).getReference();
        Invoker invoker = new Invoker(channelName, candidate);
        channel.addListener(invoker);
        this.invokers.put(methodName, invoker);
    }

    protected void removeService(String channelName, String methodName) {
        ServerChannel channel = this._bayeux.getChannel(channelName);
        if (channel != null) {
            Invoker invoker = this.invokers.remove(methodName);
            channel.removeListener(invoker);
        }
    }

    protected void removeService(String channelName) {
        ServerChannel channel = this._bayeux.getChannel(channelName);
        if (channel != null) {
            for (Invoker invoker : this.invokers.values()) {
                if (!invoker.channelName.equals(channelName)) continue;
                channel.removeListener(invoker);
            }
        }
    }

    protected void send(ServerSession toClient, String onChannel, Object data) {
        toClient.deliver(this._session.getServerSession(), onChannel, data, Promise.noop());
    }

    protected void exception(String method, ServerSession session, LocalSession local, ServerMessage message, Throwable x) {
        LOGGER.info("Exception while invoking " + this._name + "#" + method + " from " + session + " with " + message, x);
    }

    private void invoke(Method method, ServerSession fromClient, ServerMessage msg) {
        ThreadPool threadPool;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invoking {}#{} from {} with {}", this._name, method.getName(), fromClient, msg);
        }
        if ((threadPool = this.getThreadPool()) == null) {
            this.doInvoke(method, fromClient, msg);
        } else {
            threadPool.execute(() -> this.doInvoke(method, fromClient, msg));
        }
    }

    protected void doInvoke(Method method, ServerSession session, ServerMessage message) {
        try {
            Object reply = method.invoke((Object)this, session, message);
            if (reply != null) {
                this.send(session, message.getChannel(), reply);
            }
        }
        catch (Throwable x) {
            this.exception(method.toString(), session, this._session, message, x);
        }
    }

    private class Invoker
    implements ServerChannel.MessageListener {
        private final String channelName;
        private final Method method;

        public Invoker(String channelName, Method method) {
            this.channelName = channelName;
            this.method = method;
        }

        @Override
        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (AbstractService.this.isSeeOwnPublishes() || from != AbstractService.this.getServerSession()) {
                AbstractService.this.invoke(this.method, from, message);
            }
            return true;
        }
    }
}

