/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.http.AbstractHttpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometDServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(CometDServlet.class);
    private BayeuxServerImpl _bayeux;

    @Override
    public void init() throws ServletException {
        try {
            boolean export = false;
            this._bayeux = (BayeuxServerImpl)this.getServletContext().getAttribute("org.cometd.bayeux");
            if (this._bayeux == null) {
                export = true;
                this._bayeux = this.newBayeuxServer();
                for (String initParamName : Collections.list(this.getInitParameterNames())) {
                    this._bayeux.setOption(initParamName, this.getInitParameter(initParamName));
                }
                this._bayeux.setOption(ServletContext.class.getName(), this.getServletContext());
            }
            this._bayeux.start();
            if (export) {
                this.getServletContext().setAttribute("org.cometd.bayeux", this._bayeux);
            }
        }
        catch (Exception x) {
            throw new ServletException(x);
        }
    }

    public BayeuxServerImpl getBayeux() {
        return this._bayeux;
    }

    protected BayeuxServerImpl newBayeuxServer() {
        return new BayeuxServerImpl();
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("OPTIONS".equals(request.getMethod())) {
            this.serviceOptions(request, response);
            return;
        }
        AbstractHttpTransport transport = this._bayeux.findHttpTransport(request);
        if (transport == null) {
            response.sendError(400, "Unknown Bayeux Transport");
        } else {
            transport.handle(request, response);
        }
    }

    protected void serviceOptions(HttpServletRequest request, HttpServletResponse response) {
    }

    @Override
    public void destroy() {
        for (ServerSession session : this._bayeux.getSessions()) {
            ((ServerSessionImpl)session).destroyScheduler();
        }
        try {
            this._bayeux.stop();
        }
        catch (Exception x) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("", x);
            }
        }
        finally {
            this._bayeux = null;
            this.getServletContext().removeAttribute("org.cometd.bayeux");
        }
    }
}

