/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.jmx;

import java.util.Set;
import java.util.TreeSet;
import org.cometd.server.BayeuxServerImpl;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public class BayeuxServerImplMBean
extends ObjectMBean {
    private final BayeuxServerImpl bayeux;

    public BayeuxServerImplMBean(Object managedObject) {
        super(managedObject);
        this.bayeux = (BayeuxServerImpl)managedObject;
    }

    @Override
    public String getObjectContextBasis() {
        return this.bayeux.getName();
    }

    @ManagedAttribute(value="The number of ServerSessions", readonly=true)
    public int getSessionCount() {
        return this.bayeux.getSessions().size();
    }

    @ManagedAttribute(value="The number of ServerChannels", readonly=true)
    public int getChannelCount() {
        return this.bayeux.getChannels().size();
    }

    @ManagedAttribute(value="The transports known by this CometD server", readonly=true)
    public Set<String> getKnownTransportNames() {
        return new TreeSet<String>(this.bayeux.getKnownTransportNames());
    }

    @ManagedAttribute(value="The configuration option names", readonly=true)
    public Set<String> getOptionNames() {
        return new TreeSet<String>(this.bayeux.getOptionNames());
    }
}

