/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.websocket.common;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.server.websocket.common.CookieParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBayeuxContext
implements BayeuxContext {
    private static final Logger logger = LoggerFactory.getLogger(BayeuxContext.class);
    private final ServletContext context;
    private final String url;
    private final Map<String, List<String>> headers;
    private final Map<String, List<String>> parameters;
    private final Principal principal;
    private final HttpSession session;
    private final InetSocketAddress localAddress;
    private final InetSocketAddress remoteAddress;
    private final List<Locale> locales;
    private final String protocol;
    private final boolean secure;

    public AbstractBayeuxContext(ServletContext context, String uri, String query, Map<String, List<String>> headers, Map<String, List<String>> parameters, Principal principal, HttpSession session, InetSocketAddress local, InetSocketAddress remote, List<Locale> locales, String protocol, boolean secure) {
        this.context = context;
        this.url = uri + (String)(query == null ? "" : "?" + query);
        this.headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        this.headers.putAll(headers);
        this.parameters = parameters;
        this.principal = principal;
        this.session = session;
        this.localAddress = local;
        this.remoteAddress = remote;
        this.locales = locales;
        this.protocol = protocol;
        this.secure = secure;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        return values != null && values.size() > 0 ? values.get(0) : null;
    }

    @Override
    public List<String> getHeaderValues(String name) {
        return this.headers.get(name);
    }

    @Override
    public String getParameter(String name) {
        List<String> values = this.parameters.get(name);
        return values != null && values.size() > 0 ? values.get(0) : null;
    }

    @Override
    public List<String> getParameterValues(String name) {
        return this.parameters.get(name);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.principal;
    }

    @Override
    public boolean isUserInRole(String role) {
        return false;
    }

    @Override
    public String getHttpSessionId() {
        return this.session == null ? null : this.session.getId();
    }

    @Override
    public Object getHttpSessionAttribute(String name) {
        return this.session == null ? null : this.session.getAttribute(name);
    }

    @Override
    public void setHttpSessionAttribute(String name, Object value) {
        if (this.session != null) {
            this.session.setAttribute(name, value);
        }
    }

    @Override
    public void invalidateHttpSession() {
        if (this.session != null) {
            this.session.invalidate();
        }
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public List<Locale> getLocales() {
        return this.locales;
    }

    @Override
    public String getCookie(String name) {
        try {
            List<String> values = this.headers.get("Cookie");
            if (values != null) {
                for (String value : values) {
                    for (HttpCookie cookie : CookieParser.parse(value)) {
                        if (!cookie.getName().equals(name)) continue;
                        return cookie.getValue();
                    }
                }
            }
            return null;
        }
        catch (ParseException x) {
            logger.debug("Error parsing cookie " + x.getMessage() + " at index " + x.getErrorOffset(), x);
            return null;
        }
    }

    @Override
    public Object getRequestAttribute(String name) {
        return null;
    }

    @Override
    public Object getContextAttribute(String name) {
        return this.context.getAttribute(name);
    }

    @Override
    public String getContextInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    @Override
    public String getContextPath() {
        return this.context.getContextPath();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }
}

