/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.client.internal;

import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.websocket.core.client.internal.XmlHttpClientProvider;

public interface HttpClientProvider {
    public static HttpClient get() {
        XmlHttpClientProvider xmlProvider = new XmlHttpClientProvider();
        HttpClient client = xmlProvider.newHttpClient();
        if (client != null) {
            return client;
        }
        return HttpClientProvider.newDefaultHttpClient();
    }

    private static HttpClient newDefaultHttpClient() {
        HttpClient client = new HttpClient();
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("WebSocketClient@" + client.hashCode());
        client.setExecutor(threadPool);
        return client;
    }

    default public HttpClient newHttpClient() {
        return HttpClientProvider.newDefaultHttpClient();
    }
}

