/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.client.internal;

import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.ClientEndpointConfig;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.websocket.core.exception.InvalidWebSocketException;
import org.eclipse.jetty.websocket.jakarta.common.ClientEndpointConfigWrapper;

public class AnnotatedClientEndpointConfig
extends ClientEndpointConfigWrapper {
    public AnnotatedClientEndpointConfig(ClientEndpoint anno) {
        ClientEndpointConfig.Configurator configurator;
        try {
            configurator = anno.configurator().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            StringBuilder err = new StringBuilder();
            err.append("Unable to instantiate ClientEndpoint.configurator() of ");
            err.append(anno.configurator().getName());
            err.append(" defined as annotation in ");
            err.append(anno.getClass().getName());
            throw new InvalidWebSocketException(err.toString(), e);
        }
        ClientEndpointConfig build = ClientEndpointConfig.Builder.create().encoders(List.of(anno.encoders())).decoders(List.of(anno.decoders())).preferredSubprotocols(List.of(anno.subprotocols())).extensions(Collections.emptyList()).configurator(configurator).build();
        this.init(build);
    }
}

