/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.client.internal;

import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;
import org.eclipse.jetty.websocket.core.exception.InvalidWebSocketException;
import org.eclipse.jetty.websocket.core.exception.UpgradeException;
import org.eclipse.jetty.websocket.core.exception.WebSocketTimeoutException;
import org.eclipse.jetty.websocket.jakarta.client.internal.AnnotatedClientEndpointConfig;
import org.eclipse.jetty.websocket.jakarta.client.internal.BasicClientEndpointConfig;
import org.eclipse.jetty.websocket.jakarta.client.internal.JakartaClientUpgradeRequest;
import org.eclipse.jetty.websocket.jakarta.client.internal.JakartaWebSocketClientFrameHandlerFactory;
import org.eclipse.jetty.websocket.jakarta.client.internal.JsrUpgradeListener;
import org.eclipse.jetty.websocket.jakarta.common.ConfiguredEndpoint;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketContainer;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketExtensionConfig;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketFrameHandler;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketFrameHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="JSR356 Client Container")
public class JakartaWebSocketClientContainer
extends JakartaWebSocketContainer
implements WebSocketContainer {
    private static final Logger LOG = LoggerFactory.getLogger(JakartaWebSocketClientContainer.class);
    private static final AtomicReference<ContainerLifeCycle> SHUTDOWN_CONTAINER = new AtomicReference();
    protected WebSocketCoreClient coreClient;
    protected Function<WebSocketComponents, WebSocketCoreClient> coreClientFactory;
    private final JakartaWebSocketClientFrameHandlerFactory frameHandlerFactory;

    public static void setShutdownContainer(ContainerLifeCycle container) {
        SHUTDOWN_CONTAINER.set(container);
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialized {} to {}", (Object)String.format("%s@%x", SHUTDOWN_CONTAINER.getClass().getSimpleName(), SHUTDOWN_CONTAINER.hashCode()), (Object)container);
        }
    }

    public JakartaWebSocketClientContainer() {
        this(new WebSocketComponents());
    }

    public JakartaWebSocketClientContainer(HttpClient httpClient) {
        this(new WebSocketComponents(), components -> new WebSocketCoreClient(httpClient, (WebSocketComponents)components));
    }

    public JakartaWebSocketClientContainer(WebSocketComponents components) {
        this(components, WebSocketCoreClient::new);
    }

    public JakartaWebSocketClientContainer(WebSocketComponents components, Function<WebSocketComponents, WebSocketCoreClient> coreClientFactory) {
        super(components);
        this.coreClientFactory = coreClientFactory;
        this.frameHandlerFactory = new JakartaWebSocketClientFrameHandlerFactory(this);
    }

    protected HttpClient getHttpClient() {
        return this.getWebSocketCoreClient().getHttpClient();
    }

    protected WebSocketCoreClient getWebSocketCoreClient() {
        if (this.coreClient == null) {
            this.coreClient = this.coreClientFactory.apply(this.components);
            this.addManaged(this.coreClient);
        }
        return this.coreClient;
    }

    private CompletableFuture<Session> connect(JakartaClientUpgradeRequest upgradeRequest) {
        upgradeRequest.setConfiguration(this.defaultCustomizer);
        CompletableFuture<Session> futureSession = new CompletableFuture<Session>();
        try {
            WebSocketCoreClient coreClient = this.getWebSocketCoreClient();
            coreClient.connect(upgradeRequest).whenComplete((coreSession, error) -> {
                if (error != null) {
                    futureSession.completeExceptionally(JakartaWebSocketClientContainer.convertCause(error));
                    return;
                }
                JakartaWebSocketFrameHandler frameHandler = (JakartaWebSocketFrameHandler)upgradeRequest.getFrameHandler();
                futureSession.complete(frameHandler.getSession());
            });
        }
        catch (Exception e) {
            futureSession.completeExceptionally(e);
        }
        return futureSession;
    }

    public static Throwable convertCause(Throwable error) {
        if (error instanceof UpgradeException || error instanceof WebSocketTimeoutException) {
            return new IOException(error);
        }
        if (error instanceof InvalidWebSocketException) {
            return new DeploymentException(error.getMessage(), error);
        }
        return error;
    }

    private Session connect(ConfiguredEndpoint configuredEndpoint, URI destURI) throws IOException {
        Objects.requireNonNull(configuredEndpoint, "WebSocket configured endpoint cannot be null");
        Objects.requireNonNull(destURI, "Destination URI cannot be null");
        JakartaClientUpgradeRequest upgradeRequest = new JakartaClientUpgradeRequest(this, this.getWebSocketCoreClient(), destURI, configuredEndpoint);
        EndpointConfig config = configuredEndpoint.getConfig();
        if (config instanceof ClientEndpointConfig) {
            ClientEndpointConfig clientEndpointConfig = (ClientEndpointConfig)config;
            JsrUpgradeListener jsrUpgradeListener = new JsrUpgradeListener(clientEndpointConfig.getConfigurator());
            upgradeRequest.addListener(jsrUpgradeListener);
            for (Extension ext : clientEndpointConfig.getExtensions()) {
                upgradeRequest.addExtensions(new JakartaWebSocketExtensionConfig(ext));
            }
            if (clientEndpointConfig.getPreferredSubprotocols().size() > 0) {
                upgradeRequest.setSubProtocols(clientEndpointConfig.getPreferredSubprotocols());
            }
        }
        long timeout = this.getWebSocketCoreClient().getHttpClient().getConnectTimeout();
        try {
            CompletableFuture<Session> sessionFuture = this.connect(upgradeRequest);
            if (timeout > 0L) {
                return (Session)sessionFuture.get(timeout + 1000L, TimeUnit.MILLISECONDS);
            }
            return (Session)sessionFuture.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
        catch (TimeoutException e) {
            throw new IOException("Connection future timeout " + timeout + " ms for " + destURI, e);
        }
        catch (Throwable e) {
            throw new IOException("Unable to connect to " + destURI, e);
        }
    }

    @Override
    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig providedConfig, URI path) throws DeploymentException, IOException {
        return this.connectToServer(this.newEndpoint(endpointClass), providedConfig, path);
    }

    @Override
    public Session connectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException, IOException {
        return this.connectToServer(this.newEndpoint(annotatedEndpointClass), path);
    }

    @Override
    public Session connectToServer(Endpoint endpoint, ClientEndpointConfig providedConfig, URI path) throws DeploymentException, IOException {
        ClientEndpointConfig config = providedConfig;
        if (config == null) {
            config = new BasicClientEndpointConfig();
        }
        ConfiguredEndpoint instance = new ConfiguredEndpoint(endpoint, config);
        return this.connect(instance, path);
    }

    @Override
    public Session connectToServer(Object endpoint, URI path) throws DeploymentException, IOException {
        ClientEndpointConfig config = this.getAnnotatedConfig(endpoint);
        ConfiguredEndpoint instance = new ConfiguredEndpoint(endpoint, config);
        return this.connect(instance, path);
    }

    @Override
    public JakartaWebSocketFrameHandlerFactory getFrameHandlerFactory() {
        return this.frameHandlerFactory;
    }

    @Override
    public Executor getExecutor() {
        return this.getHttpClient().getExecutor();
    }

    private <T> T newEndpoint(Class<T> endpointClass) throws DeploymentException {
        try {
            return endpointClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new DeploymentException("Unable to instantiate websocket: " + endpointClass.getName());
        }
    }

    private ClientEndpointConfig getAnnotatedConfig(Object endpoint) throws DeploymentException {
        ClientEndpoint anno = endpoint.getClass().getAnnotation(ClientEndpoint.class);
        if (anno == null) {
            throw new DeploymentException("Could not get ClientEndpoint annotation for " + endpoint.getClass().getName());
        }
        return new AnnotatedClientEndpointConfig(anno);
    }

    @Override
    protected void doStart() throws Exception {
        this.doClientStart();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.doClientStop();
    }

    protected void doClientStart() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("doClientStart() {}", (Object)this);
        }
        if (this.addToContextHandler()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown registered with ContextHandler");
            }
            return;
        }
        ContainerLifeCycle shutdownContainer = SHUTDOWN_CONTAINER.get();
        if (shutdownContainer != null) {
            shutdownContainer.addManaged(this);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown registered with ShutdownContainer {}", (Object)shutdownContainer);
            }
            return;
        }
        ShutdownThread.register(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutdown registered with ShutdownThread");
        }
    }

    protected void doClientStop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("doClientStop() {}", (Object)this);
        }
        this.removeFromContextHandler();
        ContainerLifeCycle shutdownContainer = SHUTDOWN_CONTAINER.get();
        if (shutdownContainer != null && shutdownContainer.contains(this)) {
            shutdownContainer.unmanage(this);
            shutdownContainer.removeBean(this);
        }
        ShutdownThread.deregister(this);
    }

    private boolean addToContextHandler() {
        try {
            Object context = this.getClass().getClassLoader().loadClass("org.eclipse.jetty.server.handler.ContextHandler").getMethod("getCurrentContext", new Class[0]).invoke(null, new Object[0]);
            Object contextHandler = context.getClass().getMethod("getContextHandler", new Class[0]).invoke(context, new Object[0]);
            contextHandler.getClass().getMethod("addManaged", LifeCycle.class).invoke(contextHandler, this);
            return true;
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("error from addToContextHandler() for {}", (Object)this, (Object)throwable);
            }
            return false;
        }
    }

    private void removeFromContextHandler() {
        block2: {
            try {
                Object context = this.getClass().getClassLoader().loadClass("org.eclipse.jetty.server.handler.ContextHandler").getMethod("getCurrentContext", new Class[0]).invoke(null, new Object[0]);
                Object contextHandler = context.getClass().getMethod("getContextHandler", new Class[0]).invoke(context, new Object[0]);
                contextHandler.getClass().getMethod("unmanage", Object.class).invoke(contextHandler, this);
                contextHandler.getClass().getMethod("removeBean", Object.class).invoke(contextHandler, this);
            }
            catch (Throwable throwable) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("error from removeFromContextHandler() for {}", (Object)this, (Object)throwable);
            }
        }
    }
}

