/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.server.internal;

import jakarta.websocket.Decoder;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketContainer;
import org.eclipse.jetty.websocket.jakarta.common.ServerEndpointConfigWrapper;
import org.eclipse.jetty.websocket.jakarta.server.config.ContainerDefaultConfigurator;

public class AnnotatedServerEndpointConfig
extends ServerEndpointConfigWrapper {
    public AnnotatedServerEndpointConfig(JakartaWebSocketContainer containerScope, Class<?> endpointClass, ServerEndpoint anno) throws DeploymentException {
        this(containerScope, endpointClass, anno, null);
    }

    public AnnotatedServerEndpointConfig(JakartaWebSocketContainer containerScope, Class<?> endpointClass, ServerEndpoint anno, EndpointConfig baseConfig) throws DeploymentException {
        ServerEndpointConfig baseServerConfig = null;
        if (baseConfig instanceof ServerEndpointConfig) {
            baseServerConfig = (ServerEndpointConfig)baseConfig;
        }
        List<Class<? extends Decoder>> decoders = baseConfig != null && baseConfig.getDecoders() != null && baseConfig.getDecoders().size() > 0 ? baseConfig.getDecoders() : List.of(anno.decoders());
        List<Class<? extends Encoder>> encoders = baseConfig != null && baseConfig.getEncoders() != null && baseConfig.getEncoders().size() > 0 ? baseConfig.getEncoders() : List.of(anno.encoders());
        List<String> subprotocols = baseServerConfig != null && baseServerConfig.getSubprotocols() != null && baseServerConfig.getSubprotocols().size() > 0 ? baseServerConfig.getSubprotocols() : List.of(anno.subprotocols());
        String path = baseServerConfig != null && baseServerConfig.getPath() != null && baseServerConfig.getPath().length() > 0 ? baseServerConfig.getPath() : anno.value();
        ServerEndpointConfig.Configurator rawConfigurator = AnnotatedServerEndpointConfig.getConfigurator(baseServerConfig, anno);
        ServerEndpointConfig.Configurator configurator = containerScope.getObjectFactory().decorate(rawConfigurator);
        ServerEndpointConfig endpointConfig = ServerEndpointConfig.Builder.create(endpointClass, path).configurator(configurator).encoders(encoders).decoders(decoders).extensions(new ArrayList<Extension>()).subprotocols(subprotocols).build();
        if (baseConfig != null && baseConfig.getUserProperties() != null && baseConfig.getUserProperties().size() > 0) {
            endpointConfig.getUserProperties().putAll(baseConfig.getUserProperties());
        }
        this.init(endpointConfig);
    }

    private static ServerEndpointConfig.Configurator getConfigurator(ServerEndpointConfig baseServerConfig, ServerEndpoint anno) throws DeploymentException {
        ServerEndpointConfig.Configurator ret = null;
        if (baseServerConfig != null) {
            ret = baseServerConfig.getConfigurator();
        }
        if (anno != null) {
            if (anno.configurator() == ServerEndpointConfig.Configurator.class) {
                if (ret == null) {
                    return new ContainerDefaultConfigurator();
                }
                return ret;
            }
            try {
                return anno.configurator().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                StringBuilder err = new StringBuilder();
                err.append("Unable to instantiate ServerEndpoint.configurator() of ");
                err.append(anno.configurator().getName());
                err.append(" defined as annotation in ");
                err.append(anno.getClass().getName());
                throw new DeploymentException(err.toString(), e);
            }
        }
        return ret;
    }
}

