/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.server.internal;

import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.server.ServerEndpoint;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.server.FrameHandlerFactory;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import org.eclipse.jetty.websocket.jakarta.client.internal.JakartaWebSocketClientFrameHandlerFactory;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketContainer;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.websocket.jakarta.server.internal.JakartaServerUpgradeRequest;
import org.eclipse.jetty.websocket.jakarta.server.internal.PathParamIdentifier;

public class JakartaWebSocketServerFrameHandlerFactory
extends JakartaWebSocketClientFrameHandlerFactory
implements FrameHandlerFactory {
    public JakartaWebSocketServerFrameHandlerFactory(JakartaWebSocketContainer container) {
        super(container, new PathParamIdentifier());
    }

    @Override
    public JakartaWebSocketFrameHandlerMetadata getMetadata(Class<?> endpointClass, EndpointConfig endpointConfig) {
        if (Endpoint.class.isAssignableFrom(endpointClass)) {
            return this.createEndpointMetadata(endpointConfig);
        }
        ServerEndpoint anno = endpointClass.getAnnotation(ServerEndpoint.class);
        if (anno == null) {
            return super.getMetadata(endpointClass, endpointConfig);
        }
        UriTemplatePathSpec templatePathSpec = new UriTemplatePathSpec(anno.value());
        JakartaWebSocketFrameHandlerMetadata metadata = new JakartaWebSocketFrameHandlerMetadata(endpointConfig);
        metadata.setUriTemplatePathSpec(templatePathSpec);
        return this.discoverJakartaFrameHandlerMetadata(endpointClass, metadata);
    }

    @Override
    public FrameHandler newFrameHandler(Object websocketPojo, ServerUpgradeRequest upgradeRequest, ServerUpgradeResponse upgradeResponse) {
        return this.newJakartaWebSocketFrameHandler(websocketPojo, new JakartaServerUpgradeRequest(upgradeRequest));
    }
}

