/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.TransportListener;
import org.cometd.common.AbstractTransport;
import org.cometd.common.HashMapMessage;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.util.ajax.JSON;

public abstract class ClientTransport
extends AbstractTransport {
    public static final String TIMEOUT_OPTION = "timeout";
    public static final String INTERVAL_OPTION = "interval";
    public static final String MAX_NETWORK_DELAY_OPTION = "maxNetworkDelay";
    protected long _timeout = -1L;
    protected long _interval = -1L;
    protected long _maxNetworkDelay = 10000L;
    private JSON _json = new JSON(){

        protected Map newMap() {
            return new HashMap();
        }
    };
    private JSON _msgJSON = new JSON(){

        protected Map newMap() {
            return new HashMapMessage();
        }

        protected JSON contextFor(String field) {
            return ClientTransport.this._json;
        }
    };
    private JSON _batchJSON = new JSON(){

        protected Map newMap() {
            return new HashMapMessage();
        }

        protected Object[] newArray(int size) {
            return new Message.Mutable[size];
        }

        protected JSON contextFor(String field) {
            return ClientTransport.this._json;
        }

        protected JSON contextForArray() {
            return ClientTransport.this._msgJSON;
        }
    };

    protected ClientTransport(String name, Map<String, Object> options) {
        super(name, options);
        this.setOption(TIMEOUT_OPTION, this._timeout);
        this.setOption(INTERVAL_OPTION, this._interval);
        this.setOption(MAX_NETWORK_DELAY_OPTION, this._maxNetworkDelay);
    }

    public void init(BayeuxClient bayeux, HttpURI uri) {
        this._timeout = this.getOption(TIMEOUT_OPTION, this._timeout);
        this._interval = this.getOption(INTERVAL_OPTION, this._interval);
        this._maxNetworkDelay = this.getOption(MAX_NETWORK_DELAY_OPTION, this._maxNetworkDelay);
    }

    public abstract void abort();

    public abstract void reset();

    public abstract boolean accept(String var1);

    public abstract void send(TransportListener var1, Message.Mutable ... var2);

    public Message.Mutable newMessage() {
        return new HashMapMessage();
    }

    protected List<Message.Mutable> toMessages(String content) {
        Object object = this._batchJSON.parse((JSON.Source)new JSON.StringSource(content));
        if (object instanceof Message.Mutable) {
            return Collections.singletonList((Message.Mutable)object);
        }
        return Arrays.asList((Message.Mutable[])object);
    }
}

