/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.cometd.bayeux.Bayeux;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Transport;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.SessionChannel;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.LongPollingTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.client.transport.TransportRegistry;
import org.cometd.common.AbstractClientSession;
import org.cometd.common.ChannelId;
import org.cometd.common.HashMapMessage;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpSchemes;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.log.Log;

public class BayeuxClient
extends AbstractClientSession
implements Bayeux,
ClientSession,
TransportListener {
    public static final String BAYEUX_VERSION = "1.0";
    protected final ScheduledExecutorService _scheduler;
    private volatile Map<String, Object> _advice;
    private long _backoffInc = 1000L;
    private long _backoffMax = 30000L;
    private int _backoffTries = 0;
    private volatile String _clientId;
    private AbstractClientSession.Handler _connectHandler = new AbstractClientSession.Handler(){

        public void handle(AbstractClientSession session, Message.Mutable mutable) {
            BayeuxClient.this.processConnect((Message)mutable);
        }
    };
    private Map<String, ExpirableCookie> _cookies = new ConcurrentHashMap<String, ExpirableCookie>();
    private AbstractClientSession.Handler _disconnectHandler = new AbstractClientSession.Handler(){

        public void handle(AbstractClientSession session, Message.Mutable mutable) {
            BayeuxClient.this.processDisconnect((Message)mutable);
        }
    };
    private AtomicBoolean _handshakeBatch = new AtomicBoolean();
    private AbstractClientSession.Handler _handshakeHandler = new AbstractClientSession.Handler(){

        public void handle(AbstractClientSession session, Message.Mutable mutable) {
            BayeuxClient.this.processHandshake((Message)mutable);
        }
    };
    private final AtomicInteger _messageIds = new AtomicInteger();
    private final Map<String, Object> _options = new TreeMap<String, Object>();
    private final Queue<Message.Mutable> _queue = new ConcurrentLinkedQueue<Message.Mutable>();
    private Buffer _scheme;
    private final HttpURI _server;
    private volatile State _state = State.DISCONNECTED;
    private ClientTransport _transport;
    private final TransportRegistry _transportRegistry = new TransportRegistry();
    private final HttpClient _privateHttpClient;

    public BayeuxClient(HttpClient httpClient, Address address, String uri) {
        this("http://" + address + uri, httpClient);
    }

    public BayeuxClient(HttpClient httpClient, Address address, String uri, Timer timer) {
        this("http://" + address + uri, httpClient);
    }

    public BayeuxClient(HttpClient httpClient, String url) {
        this(url, Executors.newSingleThreadScheduledExecutor(), httpClient, new ClientTransport[0]);
    }

    public BayeuxClient(String url) {
        this(url, Executors.newSingleThreadScheduledExecutor(), new ClientTransport[0]);
    }

    public BayeuxClient(String url, ClientTransport ... transports) {
        this(url, Executors.newSingleThreadScheduledExecutor(), transports);
    }

    public BayeuxClient(String url, HttpClient httpClient) {
        this(url, Executors.newSingleThreadScheduledExecutor(), httpClient, new ClientTransport[0]);
    }

    public BayeuxClient(String url, ScheduledExecutorService scheduler, ClientTransport ... transports) {
        this(url, Executors.newSingleThreadScheduledExecutor(), (HttpClient)null, transports);
    }

    public BayeuxClient(String url, ScheduledExecutorService scheduler, HttpClient httpClient, ClientTransport ... transports) {
        this._scheduler = scheduler;
        if (transports != null && transports.length > 0) {
            for (ClientTransport transport : transports) {
                this._transportRegistry.add(transport);
            }
            this._privateHttpClient = null;
        } else {
            if (httpClient == null) {
                Log.debug((String)("created private HttpClient for " + this));
                httpClient = this._privateHttpClient = new HttpClient();
            } else {
                this._privateHttpClient = null;
            }
            if (!httpClient.isRunning()) {
                try {
                    httpClient.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this._transportRegistry.add(new LongPollingTransport(this._options, httpClient));
        }
        this._server = new HttpURI(url);
        this._scheme = "https".equals(this._server.getScheme()) ? HttpSchemes.HTTPS_BUFFER : HttpSchemes.HTTP_BUFFER;
        ((AbstractClientSession.AbstractSessionChannel)this.getChannel("/meta/handshake")).setHandler(this._handshakeHandler);
        ((AbstractClientSession.AbstractSessionChannel)this.getChannel("/meta/connect")).setHandler(this._connectHandler);
        ((AbstractClientSession.AbstractSessionChannel)this.getChannel("/meta/disconnect")).setHandler(this._disconnectHandler);
    }

    public void customize(HttpExchange exchange) {
        StringBuilder builder = null;
        for (String cookieName : this._cookies.keySet()) {
            ExpirableCookie cookie;
            if (builder == null) {
                builder = new StringBuilder();
            } else {
                builder.append("; ");
            }
            if ((cookie = this.getCookie(cookieName)) == null) continue;
            builder.append(QuotedStringTokenizer.quote((String)cookie.getName()));
            builder.append("=");
            builder.append(QuotedStringTokenizer.quote((String)cookie.getValue()));
        }
        if (builder != null) {
            exchange.setRequestHeader("Cookie", builder.toString());
        }
        if (this._scheme != null) {
            exchange.setScheme(this._scheme);
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.updateState(State.DISCONNECTING);
            Message.Mutable message = this.newMessage();
            message.setClientId(this.getId());
            message.setChannel("/meta/disconnect");
            message.setId((Object)this._idGen.incrementAndGet());
            this.send(message);
            while (this._batch.get() > 0) {
                this.endBatch();
            }
        } else {
            this.updateState(State.DISCONNECTED);
        }
        if (this._privateHttpClient != null) {
            try {
                this._privateHttpClient.stop();
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }
    }

    public List<String> getAllowedTransports() {
        return this._transportRegistry.getAllowedTransports();
    }

    public ExpirableCookie getCookie(String name) {
        ExpirableCookie cookie = this._cookies.get(name);
        if (cookie != null && cookie.isExpired()) {
            this._cookies.remove(name);
            cookie = null;
        }
        return cookie == null ? null : cookie;
    }

    public String getId() {
        return this._clientId;
    }

    public Set<String> getKnownTransportNames() {
        return this._transportRegistry.getKnownTransports();
    }

    public Object getOption(String qualifiedName) {
        return this._options.get(qualifiedName);
    }

    public Set<String> getOptionNames() {
        return this._options.keySet();
    }

    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this._options);
    }

    public Transport getTransport(String transport) {
        return this._transportRegistry.getTransport(transport);
    }

    public void handshake() {
        this.handshake(null);
    }

    public void handshake(Map<String, Object> template) {
        if (this._privateHttpClient != null && !this._privateHttpClient.isRunning()) {
            try {
                this._privateHttpClient.start();
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }
        List<String> allowed = this.getAllowedTransports();
        Message.Mutable message = this.newMessage();
        if (template != null) {
            message.putAll(template);
        }
        message.setChannel("/meta/handshake");
        message.put((Object)"supportedConnectionTypes", allowed);
        message.put((Object)"version", (Object)BAYEUX_VERSION);
        message.setId((Object)this._idGen.incrementAndGet());
        if (!this._handshakeBatch.getAndSet(true)) {
            this._batch.set(1);
        }
        this.updateTransport(this._transportRegistry.getTransport(allowed.get(0)));
        this.updateState(State.HANDSHAKING);
        this.doSend(message);
    }

    public State handshake(long waitMs) {
        this.handshake(null);
        this.waitFor(waitMs, State.CONNECTED, State.CONNECTING, State.DISCONNECTED, State.UNCONNECTED);
        return this._state;
    }

    public State handshake(Map<String, Object> template, long waitMs) {
        this.handshake(template);
        this.waitFor(waitMs, State.CONNECTED, State.CONNECTING, State.DISCONNECTED, State.UNCONNECTED);
        return this._state;
    }

    public boolean isConnected() {
        return this._clientId != null && this._state == State.CONNECTED;
    }

    public void setCookie(String name, String value) {
        ExpirableCookie expirableCookie = new ExpirableCookie(name, value, -1L);
        this._cookies.put(name, expirableCookie);
    }

    public void setCookie(String name, String value, int maxAge) {
        long expirationTime = System.currentTimeMillis();
        expirationTime = maxAge < 0 ? -1L : (expirationTime += TimeUnit.SECONDS.toMillis(maxAge));
        ExpirableCookie expirableCookie = new ExpirableCookie(name, value, expirationTime);
        this._cookies.put(name, expirableCookie);
    }

    public void setOption(String qualifiedName, Object value) {
        this._options.put(qualifiedName, value);
    }

    protected void doDisconnected() {
    }

    protected void doSend(Message.Mutable message) {
        if (message.isMeta()) {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.sendMeta((ClientSession)this, message)) continue;
                return;
            }
        } else {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.send((ClientSession)this, message)) continue;
                return;
            }
        }
        if (this._clientId != null) {
            message.setClientId(this._clientId);
        }
        this._transport.send(new Message[]{message});
    }

    protected AbstractClientSession.AbstractSessionChannel newChannel(ChannelId channelId) {
        return new ClientSessionChannel(channelId);
    }

    protected ChannelId newChannelId(String channelId) {
        AbstractClientSession.AbstractSessionChannel channel = (AbstractClientSession.AbstractSessionChannel)this._channels.get(channelId);
        return channel == null ? new ChannelId(channelId) : channel.getChannelId();
    }

    protected Message.Mutable newMessage() {
        if (this._transport != null) {
            return this._transport.newMessage();
        }
        return new HashMapMessage();
    }

    protected void processConnect(Message handshake) {
        boolean successful = handshake.isSuccessful();
        if (successful) {
            switch (this._state) {
                case CONNECTED: {
                    break;
                }
                case CONNECTING: {
                    this.updateState(State.CONNECTED);
                }
            }
            if (this._handshakeBatch.getAndSet(false)) {
                this.endBatch();
            }
        } else {
            this.updateState(State.UNCONNECTED);
            ++this._backoffTries;
        }
        this.followAdvice();
    }

    protected void processDisconnect(Message handshake) {
        boolean successful = handshake.isSuccessful();
        if (successful) {
            this.updateState(State.DISCONNECTED);
        }
    }

    protected void processHandshake(Message handshake) {
        boolean successful = handshake.isSuccessful();
        if (successful) {
            this._backoffTries = 0;
            ClientTransport transport = this._transportRegistry.negotiate((Object[])handshake.get((Object)"supportedConnectionTypes"), BAYEUX_VERSION).get(0);
            if (transport == null) {
                throw new UnsupportedOperationException();
            }
            if (transport != this._transport) {
                this.updateTransport(transport);
            }
            this.updateState(State.CONNECTING);
            this._clientId = handshake.getClientId();
        } else {
            ++this._backoffTries;
        }
        this.followAdvice();
    }

    protected void receive(List<Message.Mutable> incomingMessages) {
        for (Message.Mutable message : incomingMessages) {
            this.receive((Message)message, message);
        }
    }

    protected void send(Message.Mutable message) {
        if (this._batch.get() > 0) {
            this._queue.add(message);
        } else {
            this.doSend(message);
        }
    }

    protected void sendBatch() {
        int size = this._queue.size();
        while (size-- > 0) {
            Message.Mutable message = this._queue.poll();
            this.doSend(message);
        }
    }

    protected void updateTransport(ClientTransport transport) {
        if (this._transport == transport) {
            return;
        }
        if (this._transport != null) {
            this._transport.reset();
            this._transport = null;
        }
        transport.init(this, this._server, new Listener());
        this._transport = transport;
    }

    private void followAdvice() {
        String reconnect = "retry";
        long interval = 0L;
        Map<String, Object> advice = this._advice;
        if (advice != null) {
            if (advice.containsKey("reconnect")) {
                reconnect = (String)advice.get("reconnect");
            }
            if (advice.containsKey("interval")) {
                interval = ((Number)advice.get("interval")).longValue();
            }
        }
        switch (this._state) {
            case HANDSHAKING: {
                this.scheduleHandshake(interval);
                break;
            }
            case CONNECTING: {
                this.sendConnect();
                break;
            }
            case CONNECTED: {
                this._backoffTries = 0;
                this.scheduleConnect(interval);
                break;
            }
            case UNCONNECTED: {
                if ("retry".equals(reconnect)) {
                    this.scheduleConnect(interval);
                    break;
                }
                if (!"handshake".equals(reconnect)) break;
                this.scheduleHandshake(interval);
                break;
            }
        }
    }

    private String newMessageId() {
        return String.valueOf(this._messageIds.incrementAndGet());
    }

    private void scheduleConnect(long interval) {
        long backOff = (long)this._backoffTries * this._backoffInc;
        if (backOff > this._backoffMax) {
            backOff = this._backoffMax;
        }
        this._scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                BayeuxClient.this.sendConnect();
            }
        }, interval + backOff, TimeUnit.MILLISECONDS);
    }

    private void scheduleHandshake(long interval) {
        long backOff = (long)this._backoffTries * this._backoffInc;
        if (backOff > this._backoffMax) {
            backOff = this._backoffMax;
        }
        this._scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                BayeuxClient.this.handshake();
            }
        }, interval + backOff, TimeUnit.MILLISECONDS);
    }

    private void sendConnect() {
        Log.debug((String)"Connecting with transport {}", (Object)((Object)this._transport));
        Message.Mutable message = this.newMessage();
        message.setId((Object)this.newMessageId());
        message.setClientId(this._clientId);
        message.setChannel("/meta/connect");
        if (State.CONNECTING.equals((Object)this._state)) {
            message.put((Object)"connectionType", (Object)this._transport.getName());
        }
        message.setId((Object)this._idGen.incrementAndGet());
        this.doSend(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(State newState) {
        Log.debug((String)"State change: {} -> {}", (Object)((Object)this._state), (Object)((Object)newState));
        Queue<Message.Mutable> queue = this._queue;
        synchronized (queue) {
            this._state = newState;
            this._queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(long waitMs, State ... states) {
        if (states.length == 0) {
            throw new IllegalArgumentException("no stats");
        }
        long start = System.currentTimeMillis();
        Queue<Message.Mutable> queue = this._queue;
        synchronized (queue) {
            while (System.currentTimeMillis() - start < waitMs) {
                for (State s : states) {
                    if (this._state != s) continue;
                    return true;
                }
                try {
                    this._queue.wait(waitMs);
                }
                catch (InterruptedException e) {
                    long now = System.currentTimeMillis();
                    waitMs -= now - start;
                    start = now;
                }
            }
            for (State s : states) {
                if (this._state != s) continue;
                return true;
            }
            return false;
        }
    }

    public String toString() {
        return super.toString() + ":" + this._server + ":" + (Object)((Object)this._state);
    }

    @Override
    public void onConnectException(Throwable x) {
        Log.warn((String)("onConnectException " + this), (Throwable)x);
    }

    @Override
    public void onException(Throwable x) {
        Log.warn((String)("onException " + this), (Throwable)x);
    }

    @Override
    public void onExpire() {
        Log.warn((String)("onExpire " + this));
    }

    @Override
    public void onMessages(List<Message.Mutable> messages) {
    }

    @Override
    public void onProtocolError(String info) {
        Log.warn((String)("onProtocolError:" + info + " " + this));
    }

    public static enum State {
        CONNECTED,
        CONNECTING,
        DISCONNECTED,
        DISCONNECTING,
        HANDSHAKING,
        UNCONNECTED;

    }

    private class Listener
    implements TransportListener {
        private Listener() {
        }

        @Override
        public void onConnectException(Throwable x) {
            BayeuxClient.this.onConnectException(x);
            if (State.CONNECTED.equals((Object)BayeuxClient.this._state)) {
                BayeuxClient.this.updateState(State.UNCONNECTED);
            }
            BayeuxClient.this._backoffTries++;
            BayeuxClient.this.followAdvice();
        }

        @Override
        public void onException(Throwable x) {
            BayeuxClient.this.onException(x);
            if (State.CONNECTED.equals((Object)BayeuxClient.this._state)) {
                BayeuxClient.this.updateState(State.UNCONNECTED);
            }
            BayeuxClient.this._backoffTries++;
            BayeuxClient.this.followAdvice();
        }

        @Override
        public void onExpire() {
            BayeuxClient.this.onExpire();
            if (State.CONNECTED.equals((Object)BayeuxClient.this._state)) {
                BayeuxClient.this.updateState(State.UNCONNECTED);
            }
            BayeuxClient.this._backoffTries++;
            BayeuxClient.this.followAdvice();
        }

        @Override
        public void onMessages(List<Message.Mutable> messages) {
            BayeuxClient.this.onMessages(messages);
            BayeuxClient.this.receive(messages);
        }

        @Override
        public void onProtocolError(String info) {
            BayeuxClient.this.onProtocolError(info);
            if (State.CONNECTED.equals((Object)BayeuxClient.this._state)) {
                BayeuxClient.this.updateState(State.UNCONNECTED);
            }
            BayeuxClient.this._backoffTries++;
            BayeuxClient.this.followAdvice();
        }
    }

    private static class ExpirableCookie {
        private final String _name;
        private final String _value;
        private final long _expirationTime;

        private ExpirableCookie(String name, String value, long expirationTime) {
            this._name = name;
            this._value = value;
            this._expirationTime = expirationTime;
        }

        private boolean isExpired() {
            if (this._expirationTime < 0L) {
                return false;
            }
            return System.currentTimeMillis() >= this._expirationTime;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }

        public long getExpirationTime() {
            return this._expirationTime;
        }
    }

    protected class ClientSessionChannel
    extends AbstractClientSession.AbstractSessionChannel {
        protected ClientSessionChannel(ChannelId id) {
            super(id);
        }

        public void addListener(SessionChannel.SessionChannelListener listener) {
            this._listeners.add(listener);
        }

        public ClientSession getSession() {
            return BayeuxClient.this;
        }

        public void publish(Object data) {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel(this._id.toString());
            message.setData(data);
            message.setId((Object)BayeuxClient.this._idGen.incrementAndGet());
            BayeuxClient.this.send(message);
        }

        public void publish(Object data, Object id) {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel(this._id.toString());
            message.setData(data);
            if (id != null) {
                message.setId(id);
            }
            BayeuxClient.this.send(message);
        }

        public String toString() {
            return super.toString() + "@" + BayeuxClient.this._clientId;
        }

        protected void sendSubscribe() {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel("/meta/subscribe");
            message.put((Object)"subscription", (Object)this._id.toString());
            message.setId((Object)BayeuxClient.this._idGen.incrementAndGet());
            BayeuxClient.this.send(message);
        }

        protected void sendUnSubscribe() {
            Message.Mutable message = BayeuxClient.this.newMessage();
            message.setChannel("/meta/unsubscribe");
            message.put((Object)"subscription", (Object)this._id.toString());
            message.setId((Object)BayeuxClient.this._idGen.incrementAndGet());
            BayeuxClient.this.send(message);
        }
    }
}

