/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.cometd.annotation.Listener;
import org.cometd.annotation.Service;
import org.cometd.annotation.server.Configure;
import org.cometd.annotation.server.RemoteCall;
import org.cometd.annotation.server.ServerAnnotationProcessor;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.authorizer.GrantAuthorizer;
import org.cometd.server.ext.AcknowledgedMessagesExtension;
import org.cometd.server.ext.TimesyncExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometDDemoServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(CometDDemoServlet.class);

    public void init() throws ServletException {
        super.init();
        BayeuxServerImpl bayeux = (BayeuxServerImpl)this.getServletContext().getAttribute("org.cometd.bayeux");
        if (bayeux == null) {
            throw new UnavailableException("No BayeuxServer!");
        }
        bayeux.addExtension((BayeuxServer.Extension)new TimesyncExtension());
        bayeux.addExtension((BayeuxServer.Extension)new AcknowledgedMessagesExtension());
        bayeux.createChannelIfAbsent("/**", new ConfigurableServerChannel.Initializer[]{channel -> channel.addAuthorizer((Authorizer)GrantAuthorizer.GRANT_NONE)});
        bayeux.getChannel("/meta/handshake").addAuthorizer((Authorizer)GrantAuthorizer.GRANT_PUBLISH);
        ServerAnnotationProcessor processor = new ServerAnnotationProcessor((BayeuxServer)bayeux);
        processor.process((Object)new EchoRPC());
        processor.process((Object)new Monitor());
        bayeux.createChannelIfAbsent("/foo/bar/baz", new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer.Persistent()});
        if (logger.isDebugEnabled()) {
            logger.debug(bayeux.dump());
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        ((HttpServletResponse)res).sendError(503);
    }

    @Service(value="monitor")
    public static class Monitor {
        @Listener(value={"/meta/subscribe"})
        public void monitorSubscribe(ServerSession session, ServerMessage message) {
            logger.info("Monitored Subscribe from " + String.valueOf(session) + " for " + String.valueOf(message.get((Object)"subscription")));
        }

        @Listener(value={"/meta/unsubscribe"})
        public void monitorUnsubscribe(ServerSession session, ServerMessage message) {
            logger.info("Monitored Unsubscribe from " + String.valueOf(session) + " for " + String.valueOf(message.get((Object)"subscription")));
        }

        @Listener(value={"/meta/*"})
        public void monitorMeta(ServerSession session, ServerMessage message) {
            if (logger.isDebugEnabled()) {
                logger.debug(message.toString());
            }
        }
    }

    @Service(value="echo")
    public static class EchoRPC {
        @Configure(value={"/service/echo"})
        private void configureEcho(ConfigurableServerChannel channel) {
            channel.addAuthorizer((Authorizer)GrantAuthorizer.GRANT_SUBSCRIBE_PUBLISH);
        }

        @RemoteCall(value={"echo"})
        public void doEcho(RemoteCall.Caller caller, Object data) {
            logger.info("ECHO from " + String.valueOf(caller.getServerSession()) + ": " + String.valueOf(data));
            caller.result(data);
        }
    }
}

