/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples.spring.boot;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.cometd.annotation.AnnotationCometDServlet;
import org.cometd.examples.ChatService;
import org.cometd.examples.CometDDemoServlet;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletContextInitializer;

@SpringBootApplication
public class CometDApplication
implements ServletContextInitializer {
    public static void main(String[] args) {
        SpringApplication.run(CometDApplication.class, (String[])args);
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        ServletRegistration.Dynamic cometdServlet = servletContext.addServlet("cometd", AnnotationCometDServlet.class);
        cometdServlet.addMapping(new String[]{"/cometd/*"});
        cometdServlet.setAsyncSupported(true);
        cometdServlet.setLoadOnStartup(1);
        cometdServlet.setInitParameter("services", ChatService.class.getName());
        ServletRegistration.Dynamic demoServlet = servletContext.addServlet("demo", CometDDemoServlet.class);
        demoServlet.addMapping(new String[]{"/demo"});
        demoServlet.setAsyncSupported(true);
        demoServlet.setLoadOnStartup(2);
    }
}

