/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.benchmark;

import java.util.concurrent.TimeUnit;

/*
 * Exception performing whole class analysis ignored.
 */
public class SystemTimer {
    private final long nativeResolution;
    private final long emulatedResolution;

    private SystemTimer(long nativeResolution, long emulatedResolution) {
        this.nativeResolution = nativeResolution;
        this.emulatedResolution = emulatedResolution;
    }

    public long getNativeResolution() {
        return this.nativeResolution;
    }

    public long getEmulatedResolution() {
        return this.emulatedResolution;
    }

    public void sleep(long micros) {
        if (micros > this.nativeResolution) {
            SystemTimer.sleepNative((long)micros);
        } else {
            SystemTimer.sleepEmulated((long)micros);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[native=" + this.getNativeResolution() + ",emulated=" + this.getEmulatedResolution() + "]";
    }

    public static SystemTimer detect() {
        SystemTimer.detectNative();
        long nativeAccuracy = SystemTimer.detectNative();
        SystemTimer.detectEmulated();
        long emulatedAccuracy = SystemTimer.detectEmulated();
        while (emulatedAccuracy > nativeAccuracy) {
            emulatedAccuracy = SystemTimer.detectEmulated();
        }
        return new SystemTimer(nativeAccuracy, emulatedAccuracy);
    }

    private static long detectNative() {
        return SystemTimer.detect((boolean)true);
    }

    private static long detectEmulated() {
        return SystemTimer.detect((boolean)false);
    }

    private static long detect(boolean useNative) {
        long max;
        System.gc();
        long min = 0L;
        long value = max = 100000L;
        while (max > min + 1L) {
            long begin = System.nanoTime();
            if (useNative) {
                SystemTimer.sleepNative((long)value);
            } else {
                SystemTimer.sleepEmulated((long)value);
            }
            long end = System.nanoTime();
            long elapsedMicros = TimeUnit.NANOSECONDS.toMicros(end - begin);
            if (elapsedMicros > value + value / 10L) {
                min = value;
            } else {
                max = value;
            }
            value = (min + max) / 2L;
        }
        return value;
    }

    private static void sleepNative(long micros) {
        try {
            TimeUnit.MICROSECONDS.sleep(micros);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(x);
        }
    }

    private static void sleepEmulated(long micros) {
        long end = System.nanoTime() + TimeUnit.MICROSECONDS.toNanos(micros);
        while (System.nanoTime() < end) {
            Thread.yield();
        }
    }

    public static void main(String[] args) {
        SystemTimer systemTimer = SystemTimer.detect();
        System.out.println("systemTimer = " + systemTimer);
    }
}

