/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.examples;

import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletResponse;
import org.cometd.annotation.ServerAnnotationProcessor;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.examples.CometDDemoServlet;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.authorizer.GrantAuthorizer;
import org.cometd.server.ext.AcknowledgedMessagesExtension;
import org.cometd.server.ext.TimesyncExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometDDemoServlet
extends GenericServlet {
    private static final Logger logger = LoggerFactory.getLogger(CometDDemoServlet.class);

    public void init() throws ServletException {
        super.init();
        BayeuxServerImpl bayeux = (BayeuxServerImpl)this.getServletContext().getAttribute("org.cometd.bayeux");
        if (bayeux == null) {
            throw new UnavailableException("No BayeuxServer!");
        }
        bayeux.addExtension((BayeuxServer.Extension)new TimesyncExtension());
        bayeux.addExtension((BayeuxServer.Extension)new AcknowledgedMessagesExtension());
        bayeux.createChannelIfAbsent("/**", new ConfigurableServerChannel.Initializer[]{new /* Unavailable Anonymous Inner Class!! */});
        bayeux.getChannel("/meta/handshake").addAuthorizer((Authorizer)GrantAuthorizer.GRANT_PUBLISH);
        ServerAnnotationProcessor processor = new ServerAnnotationProcessor((BayeuxServer)bayeux);
        processor.process((Object)new EchoRPC());
        processor.process((Object)new Monitor());
        bayeux.createChannelIfAbsent("/foo/bar/baz", new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer.Persistent()});
        if (logger.isDebugEnabled()) {
            logger.debug(bayeux.dump());
        }
    }

    public void destroy() {
        super.destroy();
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        ((HttpServletResponse)res).sendError(503);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

