/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.common.AbstractClientSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;

public class LocalSessionImpl
extends AbstractClientSession
implements LocalSession {
    private final Queue<ServerMessage.Mutable> _queue = new ConcurrentLinkedQueue<ServerMessage.Mutable>();
    private final BayeuxServerImpl _bayeux;
    private final String _idHint;
    private ServerSessionImpl _session;

    public LocalSessionImpl(BayeuxServerImpl bayeux, String idHint) {
        this._bayeux = bayeux;
        this._idHint = idHint;
    }

    public void receive(Message.Mutable message, Promise<Void> promise) {
        super.receive(message, Promise.from(y -> {
            if ("/meta/disconnect".equals(message.getChannel()) && message.isSuccessful()) {
                this._session = null;
            }
            promise.succeed(null);
        }, arg_0 -> promise.fail(arg_0)));
    }

    protected AbstractClientSession.AbstractSessionChannel newChannel(ChannelId channelId) {
        return new LocalChannel(channelId);
    }

    protected ChannelId newChannelId(String channelId) {
        return this._bayeux.newChannelId(channelId);
    }

    protected void sendBatch() {
        int size = this._queue.size();
        while (size-- > 0) {
            ServerMessage.Mutable message = this._queue.poll();
            this.doSend(this._session, message, (Promise<ServerMessage.Mutable>)Promise.noop());
        }
    }

    public ServerSession getServerSession() {
        if (this._session == null) {
            throw new IllegalStateException("Method handshake() not invoked for local session " + (Object)((Object)this));
        }
        return this._session;
    }

    public void handshake(Map<String, Object> template, ClientSession.MessageListener callback) {
        if (this._session != null) {
            throw new IllegalStateException("Method handshake() invoke multiple times for local session " + (Object)((Object)this));
        }
        ServerSessionImpl session = new ServerSessionImpl(this._bayeux, this, this._idHint);
        ServerMessage.Mutable hsMessage = this.newMessage();
        if (template != null) {
            hsMessage.putAll(template);
        }
        String messageId = this.newMessageId();
        hsMessage.setId(messageId);
        hsMessage.setChannel("/meta/handshake");
        this.registerCallback(messageId, callback);
        this.doSend(session, hsMessage, (Promise<ServerMessage.Mutable>)Promise.from(hsReply -> {
            if (hsReply != null && hsReply.isSuccessful()) {
                this._session = session;
                ServerMessage.Mutable cnMessage = this.newMessage();
                cnMessage.setId(this.newMessageId());
                cnMessage.setChannel("/meta/connect");
                cnMessage.getAdvice(true).put("interval", -1L);
                cnMessage.setClientId(session.getId());
                this.doSend(session, cnMessage, (Promise<ServerMessage.Mutable>)Promise.from(cnReply -> {}, failure -> this.messageFailure((ServerMessage)cnMessage, (Throwable)failure)));
            }
        }, failure -> this.messageFailure((ServerMessage)hsMessage, (Throwable)failure)));
    }

    private void messageFailure(ServerMessage message, Throwable cause) {
        ServerMessage.Mutable failed = this.newMessage();
        failed.setId(message.getId());
        failed.setSuccessful(false);
        failed.setChannel(message.getChannel());
        if (message.containsKey((Object)"subscription")) {
            failed.put((Object)"subscription", message.get((Object)"subscription"));
        }
        HashMap<String, Object> failure = new HashMap<String, Object>();
        failed.put((Object)"failure", failure);
        failure.put("message", message);
        failure.put("exception", cause);
        this.receive((Message.Mutable)failed, (Promise<Void>)Promise.noop());
    }

    public void disconnect(ClientSession.MessageListener callback) {
        if (this._session != null) {
            ServerMessage.Mutable message = this.newMessage();
            String messageId = this.newMessageId();
            message.setId(messageId);
            message.setChannel("/meta/disconnect");
            message.setClientId(this._session.getId());
            this.registerCallback(messageId, callback);
            this.send((Message.Mutable)message);
            while (this.isBatching()) {
                this.endBatch();
            }
        }
    }

    public String getId() {
        if (this._session == null) {
            throw new IllegalStateException("Method handshake() not invoked for local session " + (Object)((Object)this));
        }
        return this._session.getId();
    }

    public boolean isConnected() {
        return this._session != null && this._session.isConnected();
    }

    public boolean isHandshook() {
        return this._session != null && this._session.isHandshook();
    }

    public String toString() {
        return "L:" + (this._session == null ? this._idHint + "_<disconnected>" : this._session.getId());
    }

    protected void send(Message.Mutable message) {
        if (message instanceof ServerMessage.Mutable) {
            this.send(this._session, (ServerMessage.Mutable)message);
        } else {
            ServerMessage.Mutable mutable = this.newMessage();
            mutable.putAll((Map)message);
            this.send(this._session, mutable);
        }
    }

    protected void send(ServerSessionImpl session, ServerMessage.Mutable message) {
        if (this.isBatching()) {
            this._queue.add(message);
        } else {
            this.doSend(session, message, (Promise<ServerMessage.Mutable>)Promise.noop());
        }
    }

    private void doSend(ServerSessionImpl session, ServerMessage.Mutable message, Promise<ServerMessage.Mutable> promise) {
        String messageId = message.getId();
        message.setClientId(session.getId());
        this.extendOutgoing((Message.Mutable)message, Promise.from(result -> {
            message.setId(messageId);
            if (result.booleanValue()) {
                this._bayeux.handle(session, message, (Promise<ServerMessage.Mutable>)Promise.from(r -> this._bayeux.extendReply(session, this._session, (ServerMessage.Mutable)r, (Promise<ServerMessage.Mutable>)Promise.from(reply -> {
                    if (reply != null) {
                        this.receive((Message.Mutable)reply, (Promise<Void>)Promise.from(y -> promise.succeed(reply), arg_0 -> ((Promise)promise).fail(arg_0)));
                    } else {
                        promise.succeed(null);
                    }
                }, arg_0 -> ((Promise)promise).fail(arg_0))), arg_0 -> ((Promise)promise).fail(arg_0)));
            } else {
                ServerMessage.Mutable reply = this._bayeux.createReply(message);
                this._bayeux.error(reply, "404::message_deleted");
                this.receive((Message.Mutable)reply, (Promise<Void>)Promise.from(y -> promise.succeed((Object)reply), arg_0 -> ((Promise)promise).fail(arg_0)));
            }
        }, arg_0 -> promise.fail(arg_0)));
    }

    protected ServerMessage.Mutable newMessage() {
        return this._bayeux.newMessage();
    }

    protected class LocalChannel
    extends AbstractClientSession.AbstractSessionChannel {
        protected LocalChannel(ChannelId channelId) {
            super((AbstractClientSession)LocalSessionImpl.this, channelId);
        }

        public ClientSession getSession() {
            this.throwIfReleased();
            return LocalSessionImpl.this;
        }
    }
}

